#!/bin/sh
BASEDIR=`dirname $0`
PATH=$BASEDIR/../bin:$BASEDIR/../../gtvs/tools:$PATH

export TRACES_REPOS=$BASEDIR/../../traces
DATASET=abcd/1

export RESULTS=$BASEDIR/../../results

DB_NAME=GTVS
DB_USER=root
DB_PASS=changeme
DB_HOST=localhost
DB_TRACE=abcd1
DB_TABLE=${DB_TRACE}_Flows
export DB_NAME DB_USER DB_PASS DB_HOST DB_TABLE

REAP=60
TCP_TIMEOUT=600
TCP_DONE_TIMEOUT=15
UDP_TIMEOUT=600
export REAP TCP_TIMEOUT TCP_DONE_TIMEOUT UDP_TIMEOUT

PATTERNS_DIR=/home/marco/work/click/monitoring/etc/l7-protocols
MAX_PKTS=10
MAX_BYTES=4096
export PATTERNS_DIR MAX_PKTS MAX_BYTES

MYSQL_FLAGS="-h $DB_HOST -u $DB_USER -p$DB_PASS $DB_NAME"

TAG=mytag
run-click $DATASET gtvs $TAG
if [ "$?" != "0" ]; then
  exit 1
fi

mysql $MYSQL_FLAGS < $RESULTS/$DATASET/click/gtvs/$TAG/flowsinfo.sql

create-agg $DB_TRACE | mysql $MYSQL_FLAGS
create-hn $DB_TRACE | mysql $MYSQL_FLAGS
add-trace $DB_TRACE $TRACES_REPOS/$DATASET | mysql $MYSQL_FLAGS

