/*
 * sliceflows.click -- produces a new trace where a connection cutoff of
 *                     N packets is applied to each flow and payloads are
 *                     removed for packets past the Nth
 *
 * Copyright (c) 2008 by University of Genova - DIST - TNT laboratory
 */
require(tnt);

#ifdef GDB
CrashHandler(gdb);
#endif
ControlSocket(TCP, 7777);

FromDump(@TRACE_PIPE@, STOP true, FORCE_IP true)->
#ifndef QUIET
c::Counter->
#endif
StripToNetworkHeader()->
/* If StripToNetworkHeader fails, use */
// Strip(14)->

fc::FlowCache(REAP @REAP@, DOTTEDIP false,
    TCP_TIMEOUT @TCP_TIMEOUT@,
#ifdef RESOURCE_TCP
    RESOURCE_TCP_MAX_FLOWS @RESOURCE_TCP_MAX_FLOWS@,
    RESOURCE_TCP_MAX_BUCKETS @RESOURCE_TCP_MAX_BUCKETS@,
    RESOURCE_TCP_MAX_BUCKET_LENGTH @RESOURCE_TCP_MAX_BUCKET_LENGTH@,
    RESOURCE_TCP_INITIAL_BUCKETS @RESOURCE_TCP_INITIAL_BUCKETS@,
#endif
    UDP_TIMEOUT @UDP_TIMEOUT@,
#ifdef RESOURCE_UDP
    RESOURCE_UDP_MAX_FLOWS @RESOURCE_UDP_MAX_FLOWS@,
    RESOURCE_UDP_MAX_BUCKETS @RESOURCE_UDP_MAX_BUCKETS@,
    RESOURCE_UDP_MAX_BUCKET_LENGTH @RESOURCE_UDP_MAX_BUCKET_LENGTH@,
    RESOURCE_UDP_INITIAL_BUCKETS @RESOURCE_UDP_INITIAL_BUCKETS@,
#endif
    WRRI 0, STATS 0)->
sf::SliceFlows(MAXPACKETS @MAXPACKETS@);

de::ToDump(@TRACE_FILE@, ENCAP IP, SNAPLEN 0);

sf->de;
fc[1]->de;


#ifdef DEBUG
/*for DEBUG only*/
fc[1]->
CheckIPHeader()->
cls::IPClassifier(ip proto 6, ip proto 17);

cls[0]->
CheckTCPHeader()->
tcp_drops::Counter->
ToDump(@RESULTS@/tcp_drops.pcap, ENCAP IP, SNAPLEN 0)->
Discard;

cls[1]->
CheckUDPHeader()->
udp_drops::Counter->
ToDump(@RESULTS@/udp_drops.pcap, ENCAP IP, SNAPLEN 0)->
Discard;

Script(
label dump_stats,
read fc.tcp_map_nbuckets,
read fc.tcp_active_flows,
read fc.tcp_map_max_size,
read fc.tcp_map_max_list_len,
read fc.tcp_map_find_max,
read fc.tcp_map_find_min,
read fc.tcp_map_find_avg,
read fc.tcp_map_find_e_avg,
read fc.udp_map_nbuckets,
read fc.udp_active_flows,
read fc.udp_map_max_size,
read fc.udp_map_max_list_len,
read fc.udp_map_find_max,
read fc.udp_map_find_min,
read fc.udp_map_find_avg,
read fc.udp_map_find_e_avg,
wait 1s,
goto dump_stats
);
#endif

#ifndef QUIET
Script(
label rate_stats,
printn "\rPkts: ",
printn c.count,
printn "\tBytes: ",
printn c.byte_count,
printn "\tPkt/s: ",
printn c.rate,
printn "          ",
wait 1s,
goto rate_stats
);
#endif

DriverManager(wait, write fc.clear, read fc.next_flow_id, stop);
