/*
 * gtvs.click -- produces a GTVS trace table from trace analysis
 *
 * Copyright (c) 2008 by University of Genova - DIST - TNT laboratory
 */

require(tnt);
#ifdef ENABLE_ML
require(ml);
#endif

CrashHandler(gdb);
ControlSocket(TCP, 7777);

AppMarks(
UNKNOWN:encrypted:ssl,
WWW::http,
WWW::httpaudio,
WWW::httpvideo,
/* Newsgroup */
WWW:news:nntp,
MAIL::smtp,
MAIL::pop3,
MAIL::imap,
BULK::ftp,
BULK::rsync,
ATTACK::,
/* Chat */
CHAT::irc,
/* Instant messanging */
CHAT:im:aim,
CHAT:im:jabber,
CHAT:im:msnmessenger,
CHAT:im:yahoo,
P2P::bittorrent,
P2P::edonkey,
P2P::gnutella,
P2P::ares,
P2P::directconnect,
P2P::fasttrack,
DATABASE::,
MULTIMEDIA::http-itunes,
MULTIMEDIA::http-rtsp,
MULTIMEDIA::quicktime,
MULTIMEDIA::rtsp,
VOIP::sip,
/* Services */
SERVICES::dhcp,
SERVICES::dns,
SERVICES::pnap,
SERVICES::linkproof,
/* Interactive */,
INTERACTIVE::vnc,
INTERACTIVE:remote:ssh,
INTERACTIVE:remote:telnet,
GAMES::,
GRID::globus
);

#ifdef ENABLE_ML
wekacls::@WEKACLS@;
#endif

#ifdef SQLEXPORT
ex::SQLExport(DRIVER mysql,
    URL "dbname=@DB_NAME@ user=@DB_USER@ pass=@DB_PASS@ host=@DB_HOST@",
    TABLENAME @DB_TABLE@
#ifdef APPENDTOTABLE
    , APPENDTOTABLE @APPENDTOTABLE@
#endif
    );
#else
fileex::FileExport(@RESULTS@/flowsinfo);
ex::SQLScriptExport(@RESULTS@/flowsinfo.sql, TABLENAME @DB_TABLE@,
    DROP_TABLE true, NEXT fileex);
#endif

From@DAG@Dump(@TRACE_PIPE@, STOP true, FORCE_IP true)->
c::Counter->
StripToNetworkHeader()->
/* If StripToNetworkHeader fails, use */
// Strip(14)->
MarkIPHeader()->
fc::FlowCache(REAP @REAP@, DATAEXPORTER ex, DOTTEDIP false,
    TCP_TIMEOUT @TCP_TIMEOUT@,
#ifdef TCP_DONE_TIMEOUT
    TCP_DONE_TIMEOUT @TCP_DONE_TIMEOUT@,
#endif
#ifdef RESOURCE_TCP
    RESOURCE_TCP_MAX_FLOWS @RESOURCE_TCP_MAX_FLOWS@,
    RESOURCE_TCP_MAX_BUCKETS @RESOURCE_TCP_MAX_BUCKETS@,
    RESOURCE_TCP_MAX_BUCKET_LENGTH @RESOURCE_TCP_MAX_BUCKET_LENGTH@,
    RESOURCE_TCP_INITIAL_BUCKETS @RESOURCE_TCP_INITIAL_BUCKETS@,
#endif
    UDP_TIMEOUT @UDP_TIMEOUT@,
#ifdef RESOURCE_UDP
    RESOURCE_UDP_MAX_FLOWS @RESOURCE_UDP_MAX_FLOWS@,
    RESOURCE_UDP_MAX_BUCKETS @RESOURCE_UDP_MAX_BUCKETS@,
    RESOURCE_UDP_MAX_BUCKET_LENGTH @RESOURCE_UDP_MAX_BUCKET_LENGTH@,
    RESOURCE_UDP_INITIAL_BUCKETS @RESOURCE_UDP_INITIAL_BUCKETS@,
#endif
    WRRI 0, STATS 0)->
FlowsStats()->
InterArrivalStats(SERIES_LENGTH 15, SKIP_THS false)->
PacketSizeStats(SERIES_LENGTH 15)->
l7::L7(PATTERNS "sip
bittorrent
edonkey
gnutella
ares
directconnect
fasttrack
http-itunes
http-rtsp
httpaudio
httpvideo
quicktime
rtsp
http
ssl
smtp
pop3
imap
nntp
aim
jabber
msnmessenger
yahoo
irc
ssh
telnet
ftp
dhcp
dns
vnc
globus
rsync
pnap
linkproof",
    USE_APPMARKS false,
    PATTERNS_DIR @PATTERNS_DIR@,
    MAX_PKTS @MAX_PKTS@, MAX_BYTES @MAX_BYTES@)->
#ifdef ENABLE_RTP
rtp::RtpClassifier()->
#endif
#ifdef ENABLE_ML
IPClassifier(ip proto 6)->
fe::MLFeatureExtractor()->
MLFlowCls(MLFEATUREEXTRACTOR fe, WEKACLS wekacls)->
#endif
Discard;

GTVS(fc);

#ifdef DEBUG
/*for DEBUG only*/
fc[1]->
CheckIPHeader()->
cls::IPClassifier(ip proto 6, ip proto 17);

cls[0]->
CheckTCPHeader()->
tcp_drops::Counter->
ToDump(@RESULTS@/tcp_drops.pcap, ENCAP IP, SNAPLEN 0)->
Discard;

cls[1]->
CheckUDPHeader()->
udp_drops::Counter->
ToDump(@RESULTS@/udp_drops.pcap, ENCAP IP, SNAPLEN 0)->
Discard;

Script(
label dump_stats,
read fc.tcp_map_nbuckets,
read fc.tcp_active_flows,
read fc.tcp_map_max_size,
read fc.tcp_map_max_list_len,
read fc.tcp_map_find_max,
read fc.tcp_map_find_min,
read fc.tcp_map_find_avg,
read fc.tcp_map_find_e_avg,
read fc.udp_map_nbuckets,
read fc.udp_active_flows,
read fc.udp_map_max_size,
read fc.udp_map_max_list_len,
read fc.udp_map_find_max,
read fc.udp_map_find_min,
read fc.udp_map_find_avg,
read fc.udp_map_find_e_avg,
wait 1s,
goto dump_stats
);
#endif

#ifndef QUIET
Script(
label rate_stats,
printn "\rPkts: ",
printn c.count,
printn "\tBytes: ",
printn c.byte_count,
printn "\tPkt/s: ",
printn c.rate,
printn "          ",
wait 1s,
goto rate_stats
);
#endif

DriverManager(wait, write fc.clear, read fc.next_flow_id,
read c.count,
read c.byte_count,
stop);
