#!/bin/sh

if [ "$TRACES_REPOS" = "" ]; then
  TRACES_REPOS=/mnt/`uname -n`/data/traces
  if [ ! -d "$TRACES_REPOS" -a -d /usr/groups/nprobe/traces ]; then
    TRACES_REPOS=/usr/groups/nprobe/traces
  fi
fi
if [ "$1" = "" ]; then
  echo "No dataset specified!" 1>&2
  exit 1
fi
DATASET=$1
if [ ! -d "$TRACES_REPOS/$DATASET" ]; then
  if [ -f "$DATASET" ]; then
    SINGLE_TRACE=$DATASET
    export SINGLE_TRACE
    if [ "$RESULTS" = "" ]; then
      RESULTS=`dirname $SINGLE_TRACE`
      export RESULTS
    fi
    DATASET="ds-`basename $SINGLE_TRACE`"
  else
    echo "Dataset doesn't exist: $TRACES_REPOS/$DATASET" 1>&2
    exit 1
  fi
fi

echo "TRACES_REPOS is set to: $TRACES_REPOS" 1>&2

export TRACES_REPOS
export DATASET

GNUTIME=`which time 2> /dev/null`
export GNUTIME

