th_cons = 0.8
th_flows = 5

do_heuristic1('http', 'DstPort = 80 AND Flows >= ' + th_flows.to_s,
    ['NC+10', 'NC-10', 'http'], th_cons) {|aggId|
    $gtvs.aggVerify(aggId, 'http', 'web')
}

do_heuristic1('smtp', 'DstPort = 25 AND Flows >= ' + th_flows.to_s,
    ['NC+10', 'NC-10', 'smtp'], th_cons) {|aggId|
    $gtvs.aggVerify(aggId, 'smtp', 'email')
}

do_heuristic1('smtp', 'DstPort = 587 AND Flows >= ' + th_flows.to_s,
    ['NC+10', 'NC-10', 'smtp'], th_cons) {|aggId|
    $gtvs.aggVerify(aggId, 'smtp', 'email')
}

do_heuristic1('pop3', 'DstPort = 110 AND Flows >= ' + th_flows.to_s,
    ['NC+10', 'NC-10', 'pop3'], th_cons) {|aggId|
    $gtvs.aggVerify(aggId, 'pop3', 'email')
}

do_heuristic1('imap', 'DstPort = 143 AND Flows >= ' + th_flows.to_s,
    ['NC+10', 'NC-10', 'imap'], th_cons) {|aggId|
    $gtvs.aggVerify(aggId, 'imap', 'email')
}

do_heuristic1('ssl', 'DstPort = 465 AND Flows >= ' + th_flows.to_s,
    ['NC+10', 'NC-10', 'ssl'], th_cons) {|aggId|
    $gtvs.aggVerify(aggId, 'ssmtp', 'email')
}

do_heuristic1('ssl', 'DstPort = 993 AND Flows >= ' + th_flows.to_s,
    ['NC+10', 'NC-10', 'ssl'], th_cons) {|aggId|
    $gtvs.aggVerify(aggId, 'imaps', 'email')
}

do_heuristic1('ssl', 'DstPort = 995 AND Flows >= ' + th_flows.to_s,
    ['NC+10', 'NC-10', 'ssl'], th_cons) {|aggId|
    $gtvs.aggVerify(aggId, 'pop3s', 'email')
}

do_heuristic1('rtsp', 'DstPort = 554 AND Flows >= ' + th_flows.to_s,
    ['NC+10', 'NC-10', 'rtsp'], th_cons) {|aggId|
    $gtvs.aggVerify(aggId, 'rtsp', 'streaming')
}

do_heuristic1('ssh', 'DstPort = 22 AND Flows >= ' + th_flows.to_s,
    ['NC+10', 'NC-10', 'ssh'], th_cons) {|aggId|
    $gtvs.aggVerify(aggId, 'ssh', 'remote access')
}

do_heuristic1('nntp', 'DstPort = 119 AND Flows >= ' + th_flows.to_s,
    ['NC+10', 'NC-10', 'nntp'], th_cons) {|aggId|
    $gtvs.aggVerify(aggId, 'nntp', 'news')
}

do_heuristic1('vnc', 'DstPort IN (5900, 5901, 5902) AND Flows >= ' + th_flows.to_s,
    ['NC+10', 'NC-10', 'vnc'], th_cons) {|aggId|
    $gtvs.aggVerify(aggId, 'vnc', 'remote control')
}

do_heuristic1('msnmessenger', "L7Marks LIKE '%msnmessenger%' AND Flows >= " + th_flows.to_s,
    ['msnmessenger'], th_cons) {|aggId, l7Mark|
    $gtvs.aggVerify(aggId, 'msnmessenger', 'im')
}

do_heuristic1('yahoo', "L7Marks LIKE '%yahoo%' AND Flows >= " + th_flows.to_s,
    ['yahoo'], th_cons) {|aggId, l7Mark|
    $gtvs.aggVerify(aggId, 'yahoo', 'im')
}

do_heuristic1('directconnect', "L7Marks LIKE '%directconnect%' AND Flows >= " + th_flows.to_s,
    ['NC+10', 'NC-10', 'directconnect'], th_cons) {|aggId|
    $gtvs.aggVerify(aggId, 'directconnect', 'p2p filesharing')
}

do_heuristic1('gnutella', "L7Marks LIKE '%gnutella%' AND Flows >= " + th_flows.to_s,
    ['NC+10', 'NC-10', 'gnutella'], th_cons) {|aggId|
    $gtvs.aggVerify(aggId, 'gnutella', 'p2p filesharing')
}

do_heuristic1('bittorrent', "L7Marks LIKE '%bittorrent%' AND Flows >= " + th_flows.to_s,
    ['NC+10', 'NC-10', 'bittorrent', 'edonkey'], th_cons) {|aggId|
    $gtvs.aggVerify(aggId, 'bittorrent', 'p2p filesharing')
}

do_heuristic1('edonkey', "L7Marks LIKE '%edonkey%' AND Flows >= " + th_flows.to_s,
    ['NC+10', 'NC-10', 'edonkey'], th_cons) {|aggId|
    $gtvs.aggVerify(aggId, 'edonkey', 'p2p filesharing')
}

