CREATE DATABASE GTVS;
USE GTVS;

CREATE TABLE `Traces` (
  `Name` varchar(31) NOT NULL,
  `Description` varchar(255) default NULL,
  `StartDate` datetime NOT NULL,
  `EndDate` datetime NOT NULL,
  `DataPath` varchar(255) NOT NULL,
  PRIMARY KEY  (`Name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `GtProtos` (
  `Name` varchar(15) NOT NULL,
  `Description` varchar(255) default NULL,
  PRIMARY KEY  (`Name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO `GtProtos` (`Name`, `Description`) VALUES
('aim', NULL),
('aimwebcontent', NULL),
('applejuice', NULL),
('ares', NULL),
('bittorrent', NULL),
('dhcp', NULL),
('directconnect', NULL),
('dns', NULL),
('edonkey', NULL),
('fasttrack', NULL),
('ftp', NULL),
('gnutella', NULL),
('http', NULL),
('http-itunes', NULL),
('http-rtsp', NULL),
('httpaudio', NULL),
('httpvideo', NULL),
('imap', NULL),
('imesh', NULL),
('irc', NULL),
('jabber', NULL),
('msn-filetransfe', NULL),
('msnmessenger', NULL),
('napster', NULL),
('nntp', NULL),
('openft', NULL),
('pop3', NULL),
('quicktime', NULL),
('rtsp', NULL),
('sip', NULL),
('smtp', NULL),
('ssh', NULL),
('ssl', NULL),
('telnet', NULL),
('vnc', NULL),
('yahoo', NULL),
('mssql', NULL),
('https', NULL),
('imaps', NULL),
('pop3s', NULL),
('unknown', NULL),
('ssmtp', NULL),
('ms-streaming', NULL),
('rsync', NULL),
('custom', NULL),
('aleph', NULL),
('razor2', NULL),
('globus', NULL),
('telnets', NULL),
('openbase', NULL),
('ldap', NULL),
('flash streaming', NULL),
('ntp', NULL),
('rtmp', NULL),
('mysql', NULL),
('cvsup', NULL),
('theprayer', NULL),
('arcp', NULL),
('skype', NULL),
('groove', NULL),
('applet', NULL),
('hamachi', NULL),
('flash', NULL),
('pando', NULL),
('ident', NULL),
('secondlife', NULL),
('ms-rpc', NULL),
('joltid', NULL),
('nav', NULL),
('linkproof', NULL),
('pyzor', NULL),
('snmp', NULL),
('traceroute', NULL),
('rtp', NULL),
('stun', NULL),
('av', NULL),
('isakmp', NULL),
('scan', NULL),
('dcc', NULL);

CREATE TABLE `GtApps` (
  `Name` varchar(15) NOT NULL,
  `Description` varchar(255) default NULL,
  PRIMARY KEY  (`Name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO `GtApps` (`Name`, `Description`) VALUES
('botnet', NULL),
('database', 'Mysql, Mssql, Oracle, postgres'),
('email', 'pop2, pop3, imap3, imap4, smtp'),
('ftp', NULL),
('gaming', 'Doom, Blizzard Battle Net, WoW, WarCraft, Diablo II, UO etc. except MS gaming zone'),
('grid', NULL),
('im', 'text;audio;video;datafile - MSN, AIM, yahoo messenger, ICQ, QQ, Apple iChat'),
('irc', NULL),
('malware', 'Spyware, viruses and worms, scan?'),
('ms gaming zone', 'directplay'),
('p2p filesharing', 'BitTorrent,Edonkey, Emule, Gnutella, Kazaa, SoulSeek, WinMX, Winny'),
('p2p streaming', NULL),
('proxy', 'http, socks'),
('remote access', 'ssh, telnet'),
('remote control', 'vnc, remote desktop, PCAnywhere'),
('streaming', NULL),
('sw updates', 'windows, adobe, etc, etc'),
('tunneling', 'Tunneling X11 forwarding'),
('videoconf', 'MS NetMeeting'),
('voip', 'Skype, SkypeOut, other'),
('vpn', NULL),
('web', 'Web browsing'),
('web audio', 'mediaplayer,realmedia'),
('web mail', 'Gmail, Hotmail, yahoo, institutional webmail..'),
('web services', 'Other than webbrowsing, e.g. RSS reader, desktop widgets'),
('web video', 'mediaplayer,realmedia,QT?'),
('workspace', 'MS Exchange, Lotus Workspace'),
('news', NULL),
('unknown', NULL),
('bulk', NULL),
('hidden', NULL),
('filesharing', NULL),
('tor', NULL),
('svn', NULL),
('ntp', NULL),
('services', NULL),
('chat', NULL),
('os services', NULL),
('web proxy', NULL),
('malicious', NULL);


CREATE TABLE `VerificationLog` (
  `Ts` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `User` varchar(31) NOT NULL,
  `Trace` varchar(31) NOT NULL,
  `SrcIp` int(11) unsigned default NULL,
  `SrcPort` smallint(6) unsigned default NULL,
  `DstIp` int(11) unsigned NOT NULL,
  `DstPort` smallint(6) unsigned default NULL,
  `IpProto` tinyint(4) default NULL,
  `Event` enum('verifies','questions') NOT NULL,
  `GtProto` varchar(15) default NULL,
  `GtApp` varchar(15) default NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE VIEW VerificationLogV AS
SELECT Ts, User, Trace, Event, INET_NTOA(SrcIp), SrcPort, INET_NTOA(DstIp), DstPort, IpProto, GtProto, GtApp FROM VerificationLog;


