<?php
/* SVN FILE: $Id: app_model.php 6305 2008-01-02 02:33:56Z phpnut $ */
/**
 * Application model for Cake.
 *
 * This file is application-wide model file. You can put all
 * application-wide model-related methods here.
 *
 * PHP versions 4 and 5
 *
 * CakePHP(tm) :  Rapid Development Framework <http://www.cakephp.org/>
 * Copyright 2005-2008, Cake Software Foundation, Inc.
 *								1785 E. Sahara Avenue, Suite 490-204
 *								Las Vegas, Nevada 89104
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @copyright		Copyright 2005-2008, Cake Software Foundation, Inc.
 * @link				http://www.cakefoundation.org/projects/info/cakephp CakePHP(tm) Project
 * @package			cake
 * @subpackage		cake.cake
 * @since			CakePHP(tm) v 0.2.9
 * @version			$Revision: 6305 $
 * @modifiedby		$LastChangedBy: phpnut $
 * @lastmodified	$Date: 2008-01-01 20:33:56 -0600 (Tue, 01 Jan 2008) $
 * @license			http://www.opensource.org/licenses/mit-license.php The MIT License
 */
/**
 * Application model for Cake.
 *
 * This is a placeholder class.
 * Create the same file in app/app_model.php
 * Add your application-wide methods to the class, your models will inherit them.
 *
 * @package		cake
 * @subpackage	cake.cake
 */
class AppModel extends Model {

    function setTrace($name) {
        $this->trace = $name;
        return $this->setSource($name.'_'.$this->gtTable);
    }

    function filterGtProtosAndApps(&$data, &$items, $what, $where = null) {
        if ($where === null)
            $where = $this->name;
        if (!empty($items)) {
            $items = split(',', $items);
            if (count($items) > 1) {
                $uniqueItems = array_unique($items);
                if (count($uniqueItems) < count($items)) {
                    $data[$where][$what] = $uniqueItems;
                    $data[0]['NeedsSave'.$what] = true;
                }
            }
        } else {
            $items = array();
        }
    }

	/**
	* Retrieve a list of enum values for a specific field
	*
	* @param string
	* @return array
	*/
	function getEnumList($fldName){
//debug($this->_tableInfo);
            $enums = array();
            foreach ($this->_tableInfo->value as $fldInfo) {
                if ($fldInfo['name'] != $fldName)
                    continue;
//debug($fldInfo);
		$lParenPos = strpos($fldInfo['type'], '(');
		$rParenPos = strpos($fldInfo['type'], ')');
	
		if (false != $lParenPos) {
			$type = substr($fldInfo['type'], 0, $lParenPos);
			$fieldLength = substr($fldInfo['type'], $lParenPos + 1, $rParenPos - $lParenPos - 1);
			$enumValues = split(',', $fieldLength);
			
			foreach($enumValues as $key => $enum) {
				$enum = trim($enum, "'");
				$enums[$enum] = $enum;
			}
		}
                break;
            }
            return $enums;
	}

}
?>
