function newGtProto(url) {
  var gtProto = prompt("Enter the name of the new GT proto:", "");
  if (gtProto == null || gtProto == "")
    return;

  var fForm = $('fForm');
  var elems = fForm.getElements();
  elems.each(function(gtSel) {
    if (gtSel.id.indexOf('gtProto_') != 0)
      return;
    alert('Will add ' + gtProto + ' to ' + gtSel.id);
    var opt = new Option(gtProto, gtProto);
    gtSel.add(opt, null);
  });
}

function warnIfContainsError(str) {
  if (str.indexOf('ERROR') != -1)
    alert('It seems that an error occured. Please check the debug information shown at the bottom of the page and inform Marco Canini. Thanks!');
}

var errFunc = function(t) {
    alert('Error ' + t.status + ' -- ' + t.statusText);
}

function question(url, id) {
  var trEl = $('row_' + id);

  new Ajax.Request(url,
    {
      method: 'post',
/*      onSuccess: handlerFunc,*/
      onSuccess: function(t) {
        /*alert(t.responseText);*/
        $('ajaxLog').innerHTML = t.responseText;
        warnIfContainsError(t.responseText);

        trEl.removeClassName('altRow');
        trEl.removeClassName('verified');
        /*trEl.addClassName('questioned');*/
        new Effect.Highlight(trEl,
          {startcolor:'#ffffff', endcolor:'#FFB90F', restorecolor:'#FFB90F'});
        if (url.indexOf('aggQuestion') != -1) {
          trEl.cells[5].innerHTML = "0.00%";
          trEl.cells[6].innerHTML = "100.00%";
        }
      },
      onFailure: errFunc
    });
}


function verify(url, id) {
  var trEl = $('row_' + id);
  var gtProtoEl = $('gtProto_' + id);
  var gtAppEl = $('gtApp_' + id);

  var gtProto = $F(gtProtoEl);
  var gtApp = $F(gtAppEl);

  if (gtProto == null || gtProto == "" ||
      gtApp == null || gtApp == "") {
    alert("To verify both GT proto and app must be filled in.");
    return;
  }

  gtProto = gtProto.toLowerCase();
  gtApp = gtApp.toLowerCase();

  var iProto = gtProtos.indexOf(gtProto);
  var iApp = gtApps.indexOf(gtApp);
  var newCodes = '';

  if (iProto == -1 && iApp == -1) {
    var r = confirm("Do you want to create a new GT proto (" + gtProto +
      ") and a new GT app (" + gtApp + ")?");
    if (r != true)
      return;
    newCodes = '&data[newGtProto]=1&data[newGtApp]=1';
  } else if (iProto == -1) {
    var r = confirm("Do you want to create a new GT proto (" + gtProto + ")?");
    if (r != true)
      return;
    newCodes = '&data[newGtProto]=1';
  } else if (iApp == -1) {
    var r = confirm("Do you want to create a new GT app (" + gtApp + ")?");
    if (r != true)
      return;
    newCodes = '&data[newGtApp]=1';
  }

//alert(gtProto + ' ' + gtApp);

  new Ajax.Request(url,
    {
      method: 'post',
      postBody: 'data[gtProto]='+escape(gtProto)+
                '&data[gtApp]='+escape(gtApp)+
                newCodes,
/*      onSuccess: handlerFunc,*/
      onSuccess: function(t) {
        /*alert(t.responseText);*/
        $('ajaxLog').innerHTML = t.responseText;
        warnIfContainsError(t.responseText);

        /* makes new codes available */
        if (iProto == -1)
          gtProtos.push(gtProto);
        if (iApp == -1)
          gtApps.push(gtApp);

        gtProtoEl.removeClassName('hint');
        gtAppEl.removeClassName('hint');

        trEl.removeClassName('altRow');
        trEl.removeClassName('questioned');
        /*trEl.addClassName('verified');*/
        new Effect.Highlight(trEl,
          {startcolor:'#ffffff', endcolor:'#90EE90', restorecolor:'#90EE90'});
        if (url.indexOf('aggVerify') != -1)
          trEl.cells[5].innerHTML = "100.00%";
      },
      onFailure: errFunc
    });
}

var handlerFunc = function(t) {
    alert(t.responseText);
}


function updateGtProto(gtSel) {
  var flowId = gtSel.id.substr(8);
  var sel = gtSel.options[gtSel.selectedIndex].value;
/*
  alert(flowId);
  alert(sel);
  new var handlerFunc = function(t) {
    alert(t.responseText);
}

var errFunc = function(t) {
    alert('Error ' + t.status + ' -- ' + t.statusText);
}

//For an XML response:
var handlerFunc = function(t) {
    var xmlDoc = t.responseXML.documentElement;
    //Handle data.
}
*/
  new Ajax.Request('/cake/flows/updateGtProto/' + flowId,
    {parameters:'data[Flow][GtProto]='+sel, onSuccess:handlerFunc, onFailure:errFunc});

}

