<?php 

define('INT_MINUTE', 60);
define('INT_HOUR', 3600);
define('INT_DAY', 86400);

class GtvsHelper extends Helper {
/**
 * Helpers
 *
 * @var array
 * @access private
 */
    var $helpers = Array("Html","Ajax","Javascript");

    function link($title, $url, $id, $jsFunc, $htmlOptions = array()) {
        if (!isset($htmlOptions['id']))
            $htmlOptions['id'] = 'link' . Inflector::camelize($jsFunc) . $id;
        $htmlOptions['onclick'] = 'event.returnValue = false; return false;';
        $htmlOptions['tabindex'] = '0';
        $link = $this->Html->link($title, $url, $htmlOptions);
        $link .= $this->Javascript->event("'{$htmlOptions['id']}'", "click",
            "$jsFunc('" . $this->Html->url($url) . "', '" . $id . "')");
        return $link;
    }

    function autoComplete($id, $value, $words, $inputOptions = null) {
        if (!is_array($inputOptions)) {
            $inputOptions = array();
        }
        $inputOptions['id'] = $id;
        $inputOptions['value'] = $value;
        $inputOptions['autocomplete'] = 'off';
        if (!isset($inputOptions['size']))
            $inputOptions['size'] = '15';
        if (!isset($inputOptions['maxlength']))
            $inputOptions['maxlength'] = '15';
        $ret = $this->Html->input("0/".$id, $inputOptions);
        $ret .= $this->Html->tag('div',
            array('id'=>$id.'_autoComplete',
                  'class'=>'auto_complete')).'</div>';
        $ret .= $this->Javascript->codeBlock("new Autocompleter.Local('${id}', '${id}_autoComplete', $words, {});");
        return $ret;
    }

    function openWindow($title, $url, $specs = null, $escapeTitle = true) {
        if (is_array($specs)) {
            $specs2 = '';
            foreach($specs as $key => $val) {
                $specs2 .= "$key=$val,";
            }
            $specs = rtrim($specs2, ',');
        }
        $url = $this->Html->url($url);
        $htmlOptions['onclick'] = "window.open('$url', '_blank', '$specs'); ".
            "event.returnValue = false; return false;";
        $link = $this->Html->link($title, $url, $htmlOptions, false,
            $escapeTitle);
        return $link;
    }

    function ulist($items) {
        return "<ul><li>".join("</li>\n<li>", $items)."</li></ul>";
    }

    function time_format($t) {
        if ($t < INT_MINUTE) {
            return $t.' s';
        }

        $timediff = $t;

        $days     = (int) intval($timediff / INT_DAY);
        $timediff = (int) intval($timediff - (INT_DAY * $days));
        $hours    = (int) intval($timediff / INT_HOUR);
        $timediff = (int) intval($timediff - (INT_HOUR * $hours));
        $mins     = (int) intval($timediff / INT_MINUTE);
        $timediff = (int) intval($timediff - (INT_MINUTE * $mins));
        $sec      = (int) intval($timediff);


        if ( $days )
        {
            $str[] = $days . ' d';
        }

        if ( $hours )
        {
            $str[] = $hours . ' h';
        }

        if ( $mins )
        {
            $str[] = $mins . ' m';
        }

        if ( $sec && !$hours && !$days)
        {
            $str[] = $mins . ' s';
        }

        return join(' ', $str);
    }
}
?>
