<?php

require_once('config.php');

/*
 * $flowdata['FirstPktTs']
 * $flowdata['LastPktTs']
 * $flowdata['SrcIp']
 * $flowdata['SrcPort']
 * $flowdata['DstIp']
 * $flowdata['DstPort']
 * $flowdata['IpProto']
 */
function tcpdump($tracesdir, $flowdata, $pkts = 40, $flags = null) {
    if (empty($flowdata))
        return NULL;

//print_r($flowdata);
    $firstPktTs = intval($flowdata['FirstPktTs']);
    $lastPktTs = intval($flowdata['LastPktTs']) + 1;
//    $lastPktTs = $firstPktTs + 60;

    $srcIp = long2ip($flowdata['SrcIp']);
    $dstIp = long2ip($flowdata['DstIp']);
    $srcPort = $flowdata['SrcPort'];
    $dstPort = $flowdata['DstPort'];
    $ipProto = $flowdata['IpProto'];

    $filter = "\"(src port $srcPort and ".
        "dst port $dstPort) or ".
        "(src port $dstPort and ".
        "dst port $srcPort)\"";

    $ret = $filter;

    $cmd = PCAP_IDX . " query $tracesdir $srcIp $dstIp $ipProto start $firstPktTs end $lastPktTs | ".
        TCPDUMP . " -r - -nn -c $pkts -X $filter";
    $ret .= "\n$cmd";
    $ret .= "\n".htmlspecialchars(shell_exec($cmd));
     
    return $ret;
}

?>
