<?php

require_once('config.php');

/*
 * $flowdata['FirstPktTs']
 * $flowdata['LastPktTs']
 * $flowdata['SrcIp']
 * $flowdata['SrcPort']
 * $flowdata['DstIp']
 * $flowdata['DstPort']
 * $flowdata['IpProto']
 */
function flowdump($tracesdir, $flowdata) {
    if (empty($flowdata))
        return NULL;

  $flowId = $flowdata['FlowId'];
  header("Content-Type: application/octet-stream");
  header("Content-Disposition: attachment; filename=\"flow$flowId.pcap\"");

//print_r($flowdata);
    $firstPktTs = intval($flowdata['FirstPktTs']);
    $lastPktTs = intval($flowdata['LastPktTs']) + 1;
//    $lastPktTs = $firstPktTs + 60;

    $srcIp = long2ip($flowdata['SrcIp']);
    $dstIp = long2ip($flowdata['DstIp']);
    $srcPort = $flowdata['SrcPort'];
    $dstPort = $flowdata['DstPort'];
    $ipProto = $flowdata['IpProto'];

    $filter = "\"(src port $srcPort and ".
        "dst port $dstPort) or ".
        "(src port $dstPort and ".
        "dst port $srcPort)\"";

    $cmd = PCAP_IDX . " query $tracesdir $srcIp $dstIp $ipProto start $firstPktTs end $lastPktTs | ".
        TCPDUMP . " -r - -nn -s 0 -w - $filter";
    passthru($cmd);
     
    exit();
}

?>
