<?php

class FlowsAggByDstIpPort extends AppModel
{
    var $name = 'FlowsAggByDstIpPort';
    var $primaryKey = 'DstIp'; // 'DstPort';
    var $useTable = false; 
    var $gtTable = 'FlowsAggByDstIpPort';

    function afterFind(&$ret) {
        if (!is_array($ret) || !isset($ret[0][$this->name]))
            return $ret;
        foreach ($ret as &$item) {
            $l7Marks =& $item[$this->name]['L7Marks'];
            $l7Marks = split(',', $l7Marks);

            $gtProtos =& $item[$this->name]['GtProtos'];
            $this->filterGtProtosAndApps($item, $gtProtos, 'GtProtos');
            $gtApps =& $item[$this->name]['GtApps'];
            $this->filterGtProtosAndApps($item, $gtApps, 'GtApps');
        }
        return $ret;
    }

    function updateVerified($dstIp, $dstPort = null) {
        $criteria = "DstIp = $dstIp";
        if (!empty($dstPort))
            $criteria .= " AND DstPort = $dstPort";

        $sql = "UPDATE `{$this->table}` SET ".
               "GtVerified = (SELECT COUNT(*) FROM `{$this->trace}_Flows` ".
               "WHERE $criteria AND GtState = 'verified') ".
               "WHERE $criteria";
        $ret = $this->execute($sql);
        return $this->getAffectedRows();
    }

    function update($dstIp, $dstPort, $aggIdFields, $diffVerified,
                    $diffQuestioned, $gtProto = null, $gtApp = null,
                    $gtState = null) {
        $criteria = "DstIp = $dstIp";
        if (!empty($dstPort))
            $criteria .= " AND DstPort = $dstPort";

        $sql = "UPDATE `{$this->table}` SET ";
        if (!empty($dstPort)) {
            $sql .= "GtVerified = GtVerified + ($diffVerified), ".
                "GtQuestioned = GtQuestioned + ($diffQuestioned) ";
        } else {
            /* if the update affects the entire aggregate to dstIp
               we need to be careful that GtVerified <= Flow */
            $sql .= "GtVerified = IF(GtVerified + ($diffVerified) > Flows, ".
                "Flows, GtVerified + ($diffVerified)), ".
                "GtQuestioned = IF(GtQuestioned + ($diffQuestioned) > Flows, ".
                "Flows, GtQuestioned + ($diffQuestioned)) ";
        }
        if (!empty($gtProto) && !empty($gtApp)) {
            if (empty($gtState) && ($aggIdFields == 1 || $aggIdFields == 2)) {
                /* DstIp */
                /* DstIp, DstPort */
                $sql .= ", GtProtos = '$gtProto', GtApps = '$gtApp' ";
            } else {
                /* DstIp, DstPort, SrcIp */
                /* FlowId */
                /* GtState = 'unverified' */
                $sql .= ", GtProtos = IF(GtProtos = NULL, '$gtProto', CONCAT_WS(',', '$gtProto', GtProtos)), ".
                        "GtApps = IF(GtApps = NULL, '$gtApp', CONCAT_WS(',', '$gtApp', GtApps)) ";
            }
        }
        $sql .= "WHERE $criteria";
        $ret = $this->execute($sql);
        return $this->getAffectedRows();
    }

    function reset() {
       $this->execute("UPDATE `{$this->table}` SET GtVerified = 0, GtQuestioned = 0, GtProtos = NULL, GtApps = NULL");
    }

    function findWorthForSrcIp($srcIp, $l7Marks, $excludeDstIp) {
        $l7Marks = "'".join("','", $l7Marks)."'";
        $sql = "SELECT *, COUNT(*) AS `count` FROM (".
               " SELECT * FROM `{$this->table}` AS `FlowsAggByDstIpPort`".
               " WHERE (DstIp, DstPort) IN (".
               "  SELECT DISTINCT DstIp, DstPort ".
               "  FROM `{$this->trace}_Flows` ".
               "  WHERE SrcIp = INET_ATON('$srcIp') ".
               "  AND L7Mark IN ($l7Marks) ".
               "  AND DstIp != INET_ATON('$excludeDstIp') ".
               " ) ORDER BY GtVerified DESC, Flows DESC".
               ") AS t ".
               "GROUP BY t.GtProtos";
        $ret = $this->query($sql);
        //debug($ret);
        $ret = $this->afterFind($ret);
        return $ret;
    }
}

?>
