<?php

class FlowsAggByDstIp extends AppModel
{
    var $name = 'FlowsAggByDstIp';
    var $primaryKey = 'DstIp';
    var $useTable = false;
    var $gtTable = 'FlowsAggByDstIp';

    function getAll($conditions = null, $fields = null,
                     $order = null, $limit = null, $page = 1,
                     $recursive = null) {
        $sql = "SELECT `FlowsAggByDstIp`.`DstIp`, ".
               "`FlowsAggByDstIp`.`Flows`, `FlowsAggByDstIp`.`Pkts`, ".
               "`FlowsAggByDstIp`.`TotalBytes`, ".
               "`FlowsAggByDstIp`.`PayloadBytes`, ".
               "`FlowsAggByDstIp`.`L7Marks`, `FlowsAggByDstIp`.`GtProtos`, ".
               "`FlowsAggByDstIp`.`GtApps`, `FlowsAggByDstIp`.`GtVerified`, ".
               "`FlowsAggByDstIp`.`GtQuestioned`, ".
               "`FlowsAggByDstIp`.`DstPorts`, ".
               "`HostName`.`HostName` ".
               "FROM `{$this->table}` AS `FlowsAggByDstIp` ".
               "LEFT JOIN `{$this->HostName->table}` AS `HostName` ".
               "ON (`HostName`.`Ip` = `FlowsAggByDstIp`.`DstIp`)";
        if (!empty($conditions))
            $sql .= " WHERE $conditions";
        else
            $sql .= " WHERE 1 = 1";
        if (!empty($order))
            $sql .= " ORDER BY $order";
        if (!empty($limit)) {
            if ($page > 1)
                $sql .= " LIMIT " . (($page - 1) * $limit) . ", $limit";
            else
                $sql .= " LIMIT $limit";
        }
        $ret = $this->query($sql);
        $ret = $this->afterFind($ret);
//print_r($ret);
        return $ret;
    }

    function afterFind(&$ret) {
        if (!is_array($ret) || !isset($ret[0][$this->name]))
            return $ret;
        foreach ($ret as &$item) {
            $l7Marks =& $item[$this->name]['L7Marks'];
            $l7Marks = split(',', $l7Marks);

            $dstPorts =& $item[$this->name]['DstPorts'];
            $dstPorts = split(',', $dstPorts);

            $gtProtos =& $item[$this->name]['GtProtos'];
            $this->filterGtProtosAndApps($item, $gtProtos, 'GtProtos');
            $gtApps =& $item[$this->name]['GtApps'];
            $this->filterGtProtosAndApps($item, $gtApps, 'GtApps');
        }
        return $ret;
    }

    function updateVerified($dstIp) {
        $criteria = "DstIp = $dstIp";

        $sql = "UPDATE `{$this->table}` SET ".
               "GtVerified = (SELECT COUNT(*) FROM `{$this->trace}_Flows` ".
               "WHERE $criteria AND GtState = 'verified') ".
               "WHERE $criteria";
        $ret = $this->execute($sql);
        return $this->getAffectedRows();
    }

    function update($dstIp, $aggIdFields, $diffVerified, $diffQuestioned,
                    $gtProto = null, $gtApp = null, $gtState = null) {
        $criteria = "DstIp = $dstIp";

        $sql = "UPDATE `{$this->table}` SET ".
               "GtVerified = GtVerified + ($diffVerified), ".
               "GtQuestioned = GtQuestioned + ($diffQuestioned) ";
        if (!empty($gtProto) && !empty($gtApp)) {
            if (empty($gtState)) {
                switch ($aggIdFields) {
                case 1: /* DstIp */
                    $sql .= ", GtProtos = '$gtProto', GtApps = '$gtApp' ";
                    break;
                case 2: /* DstIp, DstPort */
                    $sql .= ", GtProtos = (SELECT GROUP_CONCAT(GtProtos) ".
                            "FROM `{$this->trace}_FlowsAggByDstIpPort` ".
                            "WHERE $criteria), ".
                            "GtApps = (SELECT GROUP_CONCAT(GtApps) ".
                            "FROM `{$this->trace}_FlowsAggByDstIpPort` ".
                            "WHERE $criteria) ";
                    break;
                }
            } else {
                /* DstIp, DstPort, SrcIp */
                /* FlowId */
                /* GtState = 'unverified' */
                $sql .= ", GtProtos = IF(GtProtos = NULL, '$gtProto', CONCAT_WS(',', '$gtProto', GtProtos)), ".
                        "GtApps = IF(GtApps = NULL, '$gtApp', CONCAT_WS(',', '$gtApp', GtApps)) ";
            }
        }
        $sql .= "WHERE $criteria";
        $ret = $this->execute($sql);
        return $this->getAffectedRows();
    }

    function reset() {
       $this->execute("UPDATE `{$this->table}` SET GtVerified = 0, GtQuestioned = 0, GtProtos = NULL, GtApps = NULL");
    }

}

?>
