<?php

class Flow extends AppModel
{
    var $name = 'Flow';
    var $primaryKey = 'FlowId';
    var $useTable = false;
    var $gtTable = 'Flows';

    function aggregateBySrcIp($dstIp, $dstPort, $ipProto = null,
                     $criteria = null,
                     $order = null, $limit = null, $page = 1) {

        $sql = "SELECT `Flow`.`SrcIp`, COUNT(*) AS Flows, ".
               "SUM(Pkts0+Pkts1) AS Pkts, ".
               "SUM(TotalBytes0+TotalBytes1) AS TotalBytes, ".
               "SUM(PayloadBytes0+PayloadBytes1) AS PayloadBytes, ".
               "GROUP_CONCAT(DISTINCT L7Mark) AS L7Marks, ".
               "GROUP_CONCAT(DISTINCT GtProto) AS GtProtos, ".
               "GROUP_CONCAT(DISTINCT GtApp) AS GtApps, ".
               "SUM(IF(GtState = 'verified', 1, 0)) AS GtVerified, ".
               "SUM(IF(GtState = 'questioned', 1, 0)) AS GtQuestioned, ".
               "`HostName`.`HostName` ".
               "FROM `{$this->table}` AS `Flow` ".
               "LEFT JOIN `{$this->HostName->table}` AS `HostName` ".
               "ON (`HostName`.`Ip` = `Flow`.`SrcIp`) ".
               "WHERE `Flow`.`DstIp` = INET_ATON('$dstIp') ".
               "AND `Flow`.`DstPort` = $dstPort ";
        if (!empty($ipProto))
            $sql .= "AND `Flow`.`IpProto` = '$ipProto' ";
        if (!empty($criteria))
            $sql .= "AND $criteria ";
        $sql .= "GROUP BY `Flow`.`SrcIp`";
        if (!empty($order))
            $sql .= " ORDER BY $order";
        if (!empty($limit)) {
            if ($page > 1)
                $sql .= " LIMIT " . (($page - 1) * $limit) . ", $limit";
            else
                $sql .= " LIMIT $limit";
        }
        $ret = $this->query($sql);

        foreach ($ret as &$item) {
            $l7Marks =& $item[0]['L7Marks'];
            $l7Marks = split(',', $l7Marks);

            $gtProtos =& $item[0]['GtProtos'];
            $this->filterGtProtosAndApps($item, $gtProtos, 'GtProtos', 0);
            $gtApps =& $item[0]['GtApps'];
            $this->filterGtProtosAndApps($item, $gtApps, 'GtApps', 0);
        }

//debug($ret);
        return $ret;
    }

    function getDistinctSrcIpsCount($dstIp, $dstPort, $ipProto = null,
                    $criteria = null) {
        $sql = "SELECT COUNT(DISTINCT SrcIp) AS count ".
               "FROM `{$this->table}` AS `Flow` ".
               "WHERE `Flow`.`DstIp` = INET_ATON('$dstIp') ".
               "AND `Flow`.`DstPort` = $dstPort";
        if (!empty($ipProto))
            $sql .= " AND `Flow`.`IpProto` = '$ipProto'";
        if (!empty($criteria))
            $sql .= " AND $criteria";
        $ret = $this->query($sql);
//debug($ret);
        $count = $ret[0][0]['count'];
        return $count;
    }

    function getDistinctSrcIps($dstIp, $dstPort, $ipProto = null,
                    $criteria = null, $order = null,
                    $limit = null, $page = 1) {
        $sql = "SELECT `Flow`.`SrcIp`, COUNT( * ) AS Flows ".
               "FROM `{$this->table}` AS `Flow` ".
               "WHERE `Flow`.`DstIp` = INET_ATON('$dstIp') ".
               "AND `Flow`.`DstPort` = $dstPort";
        if (!empty($ipProto))
            $sql .= " AND `Flow`.`IpProto` = '$ipProto'";
        if (!empty($criteria))
            $sql .= " AND $criteria";
        $sql .= " GROUP BY `Flow`.`SrcIp`";
        if (!empty($order))
            $sql .= " ORDER BY $order";
        if (!empty($limit)) {
            if ($page > 1)
                $sql .= " LIMIT " . (($page - 1) * $limit) . ", $limit";
            else
                $sql .= " LIMIT $limit";
        }
        $ret = $this->query($sql);
//debug($ret);
        return $ret;
    }

    function findAll($conditions = null, $fields = null,
                     $order = null, $limit = null, $page = 1,
                     $recursive = null) {
        if ($fields == null) {
            $fields = array(
                'FlowId', 'SrcIp', 'SrcPort', 'DstIp', 'DstPort', 'IpProto',
                'FirstPktTs', 'LastPktTs',
                'Pkts0 + (Pkts1) AS Pkts', // a + (b) syntax to please cake
                'TotalBytes0 + (TotalBytes1) AS TotalBytes',
                'PayloadBytes0 + (PayloadBytes1) AS PayloadBytes',
                'L7Mark',
                'GtProto', 'GtApp', 'GtState');
//            $fields = 'SrcIp, SrcPort, DstIp, DstPort, FirstPktTs, LastPktTs, (`Flow`.`Pkts0`+Pkts1) AS Pkts';
        }
        return parent::findAll($conditions, $fields, $order, $limit, $page, $recursive);
    }


    function markVerified($gtProto, $gtApp, $gtState, $dstIp, $dstPort = null, $srcIp = null) {
        $newVerified = $this->_updateState('verified', $gtProto, $gtApp,
            $dstIp, $dstPort, $srcIp, 'unverified');
        $wereQuestioned = 0;
        if ($gtState != 'unverified') {
            $wereQuestioned = $this->_updateState('verified', $gtProto, $gtApp,
                $dstIp, $dstPort, $srcIp, 'questioned');
            $newVerified += $wereQuestioned;
            $this->_updateState('verified', $gtProto, $gtApp,
                $dstIp, $dstPort, $srcIp, 'verified');
        }
        return array($newVerified, $wereQuestioned);
    }

    function markQuestioned($dstIp, $dstPort = null, $srcIp = null) {
        $newQuestioned = $this->_updateState('questioned', null, null,
            $dstIp, $dstPort, $srcIp, 'unverified');
        $wereVerified = $this->_updateState('questioned', null, null,
            $dstIp, $dstPort, $srcIp, 'verified');
        $newQuestioned += $wereVerified;
        $this->_updateState('questioned', null, null,
            $dstIp, $dstPort, $srcIp, 'questioned');
        return array($newQuestioned, $wereVerified);
    }

    function _updateState($gtState, $gtProto, $gtApp,
                          $dstIp, $dstPort = null, $srcIp = null,
                          $withGtState = null) {
        $sql = "UPDATE `{$this->table}` SET ".
               "GtState = '$gtState' ";
        if ($gtProto !== null) /* empty string is allowed here */
            $sql .= ", GtProto = '$gtProto' ";
        if ($gtApp !== null) /* empty string is allowed here */
            $sql .= ", GtApp = '$gtApp' ";
        $sql .= "WHERE DstIp = $dstIp";
        if (!empty($dstPort))
            $sql .= " AND DstPort = $dstPort";
        if (!empty($srcIp))
            $sql .= " AND SrcIp = $srcIp";
        if (!empty($withGtState))
            $sql .= " AND GtState = '$withGtState'";
        $ret = $this->execute($sql);
        return $this->getAffectedRows();
    }

    function reset() {
       $this->execute("UPDATE `{$this->table}` SET GtProto = NULL, GtApp = NULL, GtState = 'unverified'");
    }

    function getGtProtoAppHits() {
       $sql = "SELECT GtProto, GtApp FROM ".
              "(SELECT GtProto, GtApp, COUNT(*) AS count FROM ".
              "`{$this->table}` AS `Flow` WHERE GtProto IS NOT NULL AND ".
              "GtApp IS NOT NULL GROUP BY GtProto, GtApp ".
              "ORDER BY count DESC) AS t GROUP BY GtProto";
       return $this->query($sql);
    }

    function getL7MarkBreakdownTo($dstIp, $dstPort = null, $srcIp = null, $ipProto = null) {
        $sql = "SELECT L7Mark, COUNT(*) AS `count` ".
               "FROM `{$this->table}` AS `Flow` ".
               "WHERE DstIp = INET_ATON('$dstIp') ";
        if (!empty($dstPort))
            $sql .= "AND DstPort = $dstPort ";
        if (!empty($srcIp))
            $sql .= "AND SrcIp = INET_ATON('$srcIp') ";
        if (!empty($ipProto))
            $sql .= "AND IpProto = '$ipProto' ";
        $sql .= "GROUP BY L7Mark ORDER BY `count` DESC";

        return $this->query($sql);
    }

}

?>
