<?php

function ulist_format($data) {
    $this->log("ulist_format is deprecated.");
    if (!is_array($data))
        return $data;
    if (count($data) == 1)
        return $data[0];

    $ret = "<ul>";
    foreach ($data as $i) {
        $ret .= "<li>$i</li>";
    }
    $ret .= "</ul>";
    return $ret;
}

function findGtProto($l7Marks, $gtProtos, $dstPort = null) {
//debug($l7Marks);
//debug($gtProtos);
    $gtProto = null;

    if (is_array($gtProtos)) {
        if (count($gtProtos) == 1) {
            return array($gtProtos[0], false);
        }

        if (count($gtProtos) > 1) {
            return array(null, false);
        }
    } elseif (!empty($gtProtos)) {
        return array($gtProtos, false);
    }

    if (is_array($l7Marks)) {
        for($i = 0;
            $i < count($l7Marks) && strpos($l7Marks[$i], 'NC') === 0;
            $i++);
        if ($i == count($l7Marks))
            return array(null, false);
        $gtProto = $l7Marks[$i];
    } elseif (strpos($l7Marks, 'NC') === false) {
        $gtProto = $l7Marks;
    }
    if ($gtProto == 'ssl' && $dstPort == 443)
        $gtProto = 'https';
    elseif ($gtProto == 'ssl' && $dstPort == 465)
        $gtProto = 'ssmtp';
    elseif ($gtProto == 'ssl' && $dstPort == 993)
        $gtProto = 'imaps';
    elseif ($gtProto == 'ssl' && $dstPort == 995)
        $gtProto = 'pop3s';
    return array($gtProto, true);
}

//debug(findGtProto(array('http'), array()));

function findGtApp($gtProto, $gtApps) {
    vendor('gtapphint');

    if (is_array($gtApps)) {
        if (count($gtApps) == 1) {
            return array($gtApps[0], false);
        }

        if (count($gtApps) > 1) {
            return array(null, false);
        }
    } elseif (!empty($gtApps)) {
        return array($gtApps, false);
    }
    if (empty($gtProto))
        return array(null, false);

    return array(gtAppHint($gtProto), true);
}

class TracesController extends AppController
{
    var $name = 'Traces';
    var $components = array('Pagination'/*, 'RequestHandler'*/);
    var $helpers = array('Pagination', 'Number', 'Ajax', 'Javascript', 'Gtvs', 'Crumb');
    var $uses = array('Trace', 'Flow', 'FlowsAggByDstIp', 'FlowsAggByDstIpPort', 'HostName', 'GtProto', 'GtApp', 'VerificationLog');

    function index() {
        $traces = $this->Trace->findAll();
        $this->set('traces', $traces);
    }

    function _initTrace($trace) {
        $this->HostName->setTrace($trace);
        $this->Flow->HostName = $this->HostName;
        $this->FlowsAggByDstIp->HostName = $this->HostName;
        $this->Flow->setTrace($trace);
        $this->FlowsAggByDstIp->setTrace($trace);
        $this->FlowsAggByDstIpPort->setTrace($trace);

        $this->set('trace', $trace);
    }

    function reset($trace) {
        $this->_initTrace($trace);
        $this->Flow->reset();
        $this->FlowsAggByDstIp->reset();
        $this->FlowsAggByDstIpPort->reset();
    }

    function rebuildGtAppHints() {
        $trace = $this->Trace->find();
        $this->Flow->setTrace($trace['Trace']['Name']);
        $hits = $this->Flow->getGtProtoAppHits();
        if (count($hits) > 0) {
            $code = <<<EOP
<?php
function gtAppHint(\$gtProto) {
    static \$hints = array(

EOP;
            foreach ($hits as $hit) {
                $code .= sprintf("        '%s' => '%s',\n",
                    $hit['Flow']['GtProto'], $hit['Flow']['GtApp']);
            }
            $code = rtrim($code, ',');
            $code .= <<<EOE
    );
    return @\$hints[\$gtProto];
}
?>
EOE;
            $this->set('hits', $hits);
            $this->set('code', $code);
            $fd = fopen(APP.'vendors'.DS.'gtapphint.php', 'w');
            if ($fd) {
                fwrite($fd, $code);
                fclose($fd);
                $this->set('fail', false);
            } else {
                $this->set('fail', true);
            }
        } else {
            $this->set('hits', 'No hints provided from database!');
            $this->set('fail', true);
            $this->set('code', '');
        }
    }

    function view($trace, $dstIp, $dstPort, $srcIp, $ipProto = null) {
        vendor('ianas');
        $this->_initTrace($trace);

        $showCriteria = $this->_getShowCriteria(false);
        $criteria = "DstIp = INET_ATON('$dstIp') AND DstPort = $dstPort AND SrcIp = INET_ATON('$srcIp')";
        if (!empty($ipProto))
            $criteria .= " AND IpProto = '$ipProto'";
        if (!empty($showCriteria))
            $criteria .= " AND $showCriteria";
        $this->set('dstIp', $dstIp);
        $this->set('dstPort', $dstPort);
        $this->set('srcIp', $srcIp);
        $this->set('ipProto', $ipProto);

        $total = $this->Flow->findCount($criteria, 0);
        list($order,$limit,$page) = $this->Pagination->init($criteria, array(), array('total' => $total, 'show' => 8, 'sortBy' => 'FirstPktTs', 'sortByClass' => 'Flows', 'direction' => 'ASC'));
//debug($order);
        $this->set('items', $this->Flow->findAll($criteria, NULL, $order, $limit, $page));
        $dstHost = $this->HostName->find("Ip = INET_ATON('$dstIp')");
        if ($dstHost && !empty($dstHost['HostName']['HostName']))
            $this->set('dstHost', $dstHost['HostName']['HostName']);
        $srcHost = $this->HostName->find("Ip = INET_ATON('$srcIp')");
        if ($srcHost && !empty($srcHost['HostName']['HostName']))
            $this->set('srcHost', $srcHost['HostName']['HostName']);

        //debug($this->generateFieldNames());
//debug($this->Flow->getEnumList('GtProto'));
        $this->set('gtProtoOptions', $this->Flow->getEnumList('GtProto'));

        $this->_setGtProtosAndApps();
    }

    function _setGtProtosAndApps() {
        $gtProtos = $this->GtProto->findAll();
        $this->set('gtProtos', $gtProtos);
        $this->set('jsGtProtos', $this->GtProto->toAutoCompletionJsArray($gtProtos));

        $gtApps = $this->GtApp->findAll();
        $this->set('gtApps', $gtApps);
        $this->set('jsGtApps', $this->GtApp->toAutoCompletionJsArray($gtApps));
    }

    function _getShowCriteria($isAgg, $options = array()) {
//        debug($this->params);
        $criteria = array();
        if (isset($options['filter']) && $options['filter'] == true
            && isset($_GET['flt'])) {
            array_push($criteria, $_GET['flt']);
        }
        if (isset($_GET['gtState'])) {
            $show = strtolower($_GET['gtState']);
            $this->set('showArg', "gtState=$show");
            switch ($show) {
            case 'unverified':
                $c = ($isAgg) ? "GtVerified < Flows" : "GtState != 'verified'";
                array_push($criteria, $c);
                break;
            case 'questioned':
                $c = ($isAgg) ? "GtQuestioned > 0" : "GtState = 'questioned'";
                array_push($criteria, $c);
                break;
            case 'verified':
                $c = ($isAgg) ? "GtVerified >= Flows" : "GtState = 'verified'";
                array_push($criteria, $c);
                break;
            }
        }
        $this->set('showArg', null);
        return count($criteria) == 0 ? null : join(" AND ", $criteria);
    }

    function aggByDstIp($trace) {
        $criteria = $this->_getShowCriteria(true, array('filter'=>true));
        $this->_initTrace($trace);

        $total = $this->FlowsAggByDstIp->findCount($criteria, 0);
        list($order,$limit,$page) = $this->Pagination->init($criteria, array(), array('total' => $total, 'show' => 8, 'sortBy' => 'Flows', 'sortByClass' => 'FlowsAggByDstIp', 'direction' => 'DESC'));
        $this->set('items', $this->FlowsAggByDstIp->getAll($criteria, NULL, $order, $limit, $page));

        $this->set('gtProtoOptions', $this->Flow->getEnumList('GtProto'));

        $this->_setGtProtosAndApps();
    }

    function aggByDstIpPort($trace, $dstIp) {
        vendor('ianas');
        $this->_initTrace($trace);

        $showCriteria = $this->_getShowCriteria(true);
        $criteria = "DstIp = INET_ATON('$dstIp')";
        if (!empty($showCriteria))
            $criteria .= ' AND ' . $showCriteria;

        $this->set('dstIp', $dstIp);
        $total = $this->FlowsAggByDstIpPort->findCount($criteria, 0);
        list($order,$limit,$page) = $this->Pagination->init($criteria, array(), array('total' => $total, 'show' => 8, 'sortBy' => 'DstPort', 'sortByClass' => 'FlowsAggByDstIpPort', 'direction' => 'ASC'));
        $this->set('items', $this->FlowsAggByDstIpPort->findAll($criteria, NULL, $order, $limit, $page));
        $dstHost = $this->HostName->find("Ip = INET_ATON('$dstIp')");
        if ($dstHost && !empty($dstHost['HostName']['HostName']))
            $this->set('dstHost', $dstHost['HostName']['HostName']);

        $this->set('gtProtoOptions', $this->Flow->getEnumList('GtProto'));

        $this->_setGtProtosAndApps();
    }

    function aggByDstIpPortSrcIp($trace, $dstIp, $dstPort, $ipProto = null) {
        vendor('ianas');
        $this->_initTrace($trace);

        $showCriteria = $this->_getShowCriteria(false);
        $this->set('dstIp', $dstIp);
        $this->set('dstPort', $dstPort);
        $this->set('ipProto', $ipProto);
        $total = $this->Flow->getDistinctSrcIpsCount($dstIp, $dstPort,
            $ipProto, $showCriteria);
        list($order,$limit,$page) = $this->Pagination->init(NULL, array(), array('total' => $total, 'show' => 8, 'sortBy' => 'Flows', 'direction' => 'DESC'));
        $this->set('items', $this->Flow->aggregateBySrcIp($dstIp, $dstPort,
            $ipProto, $showCriteria, $order, $limit, $page));
        $dstHost = $this->HostName->find("Ip = INET_ATON('$dstIp')");
        if ($dstHost && !empty($dstHost['HostName']['HostName']))
            $this->set('dstHost', $dstHost['HostName']['HostName']);

        $this->set('gtProtoOptions', $this->Flow->getEnumList('GtProto'));
        $this->_setGtProtosAndApps();
    }

    function inspect($trace, $flowId) {
        vendor('tcpdump');
        $this->Flow->setTrace($trace);
        $this->set('trace', $trace);
        $trace = $this->Trace->find("Name = '$trace'");

        $flow = $this->Flow->find("FlowId = $flowId");

        $this->set('flowId', $flowId);
        $this->set('dump', tcpdump($trace['Trace']['DataPath'], $flow['Flow']));
    }

    function inspectOne($trace, $dstIp, $dstPort = null, $srcIp = null) {
        $this->Flow->setTrace($trace);
        $criteria = "DstIp = INET_ATON('$dstIp')";
        if (!empty($dstPort))
            $criteria .= " AND DstPort = $dstPort";
        if (!empty($srcIp)) 
            $criteria .= " AND SrcIp = INET_ATON('$srcIp')";
        $flow = $this->Flow->find($criteria, array('FlowId'));
        $this->redirect("/traces/inspect/$trace/".$flow['Flow']['FlowId']);
    }

    function download($trace, $flowId) {
        vendor('flowdump');
        $this->Flow->setTrace($trace);
        $trace = $this->Trace->find("Name = '$trace'");

        $flow = $this->Flow->find("FlowId = $flowId");
        Configure::write('debug', false);
        flowdump($trace['Trace']['DataPath'], $flow['Flow']);
    }

    function verify($trace, $flowId) {
        $this->_initTrace($trace);

//debug($this->params);
        if (!empty($this->params['data']['gtProto']) &&
            !empty($this->params['data']['gtApp'])) {

//var_dump($id);

            $gtProto = strtolower($this->params['data']['gtProto']);
            $gtApp = strtolower( $this->params['data']['gtApp']);

            if (isset($this->params['data']['newGtProto'])) {
                $newGtProto['GtProto']['Name'] = $gtProto;
                $this->GtProto->save($newGtProto);
            }
            if (isset($this->params['data']['newGtApp'])) {
                $newGtApp['GtApp']['Name'] = $gtApp;
                $this->GtApp->save($newGtApp);
            }

            $flow = $this->Flow->find("FlowId = $flowId");
            $prevState = $flow['Flow']['GtState'];

            $this->Flow->id = $flowId;
            $data['Flow']['GtProto'] = $gtProto;
            $data['Flow']['GtApp'] = $gtApp;
            $data['Flow']['GtState'] = 'verified';

            $dstIp = $flow['Flow']['DstIp'];
            $dstPort = $flow['Flow']['DstPort'];

            if ($this->Flow->save($data)) {
                switch ($prevState) {
                case 'unverified':
                    $newVerified = 1;
                    $wereQuestioned = 0;
                    break;
                case 'verified':
                    $newVerified = 0;
                    $wereQuestioned = 0;
                    break;
                case 'questioned':
                    $newVerified = 1;
                    $wereQuestioned = 1;
                    break;
                }

                $this->FlowsAggByDstIpPort->update($dstIp, $dstPort, 0, $newVerified, -($wereQuestioned), $gtProto, $gtApp);
                $this->FlowsAggByDstIp->update($dstIp, 0, $newVerified, -($wereQuestioned), $gtProto, $gtApp);

                $this->_logVerify($trace, $flow['Flow']['SrcIp'],
                    $flow['Flow']['SrcPort'], $dstIp, $dstPort,
                    null /*$ipProto*/, $gtProto, $gtApp);
            }
            $this->set('ret', "$flowId : $gtProto");
            $this->render('ajaxDone', 'ajax');
        }
    }

    function aggVerify($trace, $aggId, $gtState = null) {
        $this->_initTrace($trace);
        //debug($this->params);

        if (!empty($this->params['data']['gtProto']) &&
            !empty($this->params['data']['gtApp'])) {

            $gtProto = $this->params['data']['gtProto'];
            $gtApp = strtolower( $this->params['data']['gtApp']);

            if (isset($this->params['data']['newGtProto'])) {
                $newGtProto['GtProto']['Name'] = $gtProto;
                $this->GtProto->save($newGtProto);
            }
            if (isset($this->params['data']['newGtApp'])) {
                $newGtApp['GtApp']['Name'] = $gtApp;
                $this->GtApp->save($newGtApp);
            }

            $dstPort = null;
            $srcIp = null;

            $aggId = split('_', $aggId);
            $aggIdFields = count($aggId); 

            $dstIp = array_shift($aggId);
            $dstPort = array_shift($aggId); /* if array is empty NULL is returned */
            $srcIp = array_shift($aggId);


            list($newVerified, $wereQuestioned) = $this->Flow->markVerified($gtProto, $gtApp, $gtState, $dstIp, $dstPort, $srcIp);
            $this->FlowsAggByDstIpPort->update($dstIp, $dstPort, $aggIdFields, $newVerified, -($wereQuestioned), $gtProto, $gtApp, $gtState);
            $this->FlowsAggByDstIp->update($dstIp, $aggIdFields, $newVerified, -($wereQuestioned), $gtProto, $gtApp, $gtState);

            $this->_logVerify($trace, $srcIp, null, $dstIp, $dstPort,
                null /*$ipProto*/, $gtProto, $gtApp);

            $this->set('ret', "$aggId : $gtProto, $gtApp");
            $this->render('ajaxDone', 'ajax');
        }
    }

    function question($trace, $flowId) {
        $this->_initTrace($trace);

        $flow = $this->Flow->find("FlowId = $flowId");
        $prevState = $flow['Flow']['GtState'];

        $this->Flow->id = $flowId;
        $data['Flow']['GtState'] = 'questioned';

        $dstIp = $flow['Flow']['DstIp'];
        $dstPort = $flow['Flow']['DstPort'];

        if ($this->Flow->save($data)) {
            switch ($prevState) {
            case 'unverified':
                $newQuestioned = 1;
                $wereVerified = 0;
                break;
            case 'questioned':
                $newQuestioned = 0;
                $wereVerified = 0;
                break;
            case 'verified':
                $newQuestioned = 1;
                $wereVerified = 1;
                break;
            }

            $this->FlowsAggByDstIpPort->update($dstIp, $dstPort, 0, -($wereVerified), $newQuestioned);
            $this->FlowsAggByDstIp->update($dstIp, 0, -($wereVerified), $newQuestioned);

            $this->_logQuesion($trace, $flow['Flow']['SrcIp'],
                $flow['Flow']['SrcPort'], $dstIp, $dstPort,
                null /*$ipProto*/);
        }
        $this->set('ret', "$flowId : questioned");
        $this->render('ajaxDone', 'ajax');
    }

    function aggQuestion($trace, $aggId) {
        $this->_initTrace($trace);

        $aggId = split('_', $aggId);

        $dstIp = array_shift($aggId);
        $dstPort = array_shift($aggId); /* if array is empty NULL is returned */
        $srcIp = array_shift($aggId);

        list($newQuestioned, $wereVerified) = $this->Flow->markQuestioned($dstIp, $dstPort, $srcIp);
        if ($newQuestioned > 0 || $wereVerified > 0) {
            $this->FlowsAggByDstIpPort->update($dstIp, $dstPort, 0, -($wereVerified), $newQuestioned);
            $this->FlowsAggByDstIp->update($dstIp, 0, -($wereVerified), $newQuestioned);
        }

        $this->_logQuesion($trace, $srcIp, null, $dstIp, $dstPort,
            null /*$ipProto*/);

        $this->set('ret', "$aggId : questioned");
        $this->render('ajaxDone', 'ajax');
    }

    function l7BreakdownTo($trace, $dstIp, $dstPort = null,
                           $srcIp = null, $ipProto = null) {
        $this->Flow->setTrace($trace);
        $bd = $this->Flow->getL7MarkBreakdownTo($dstIp, $dstPort, $srcIp,
            $ipProto);
        $this->set('bd', $bd);
        $this->render('l7BreakdownTo', 'ajax');
    }

    function search() {
        $q = null;
        if (isset($_GET['q'])) {
            $q = trim($_GET['q']);
            if (preg_match("/^(\d){1,3}\.(\d){1,3}\.(\d){1,3}\.(\d){1,3}$/", $q)) {
                $ip = sprintf("%u", ip2long($q));
            } elseif (preg_match("/^dport (\d+)$/", $q, $matches)) {
                $dport = $matches[1];
            }
            $traces = $this->Trace->findAll(null, array('Name'));
            $res = array();
            $rescount = 0;
            foreach ($traces as $trace) {
                $trace = $trace['Trace']['Name'];
                $this->HostName->setTrace($trace);
                $this->FlowsAggByDstIp->HostName = $this->HostName;
                $this->FlowsAggByDstIp->setTrace($trace);

                if (!isset($dport)) {
                    if (!isset($ip)) {
                    /* search by hostname */
                    $hostnames = $this->HostName->findAll("HostName LIKE '%$q%'");
                    if (empty($hostnames))
                    continue;

                    foreach ($hostnames as $hostname) {
                    $ips[] = $hostname['HostName']['Ip'];
                    }
                    $ip = join(',', $ips);
                    }

                    $items = $this->FlowsAggByDstIp->getAll("DstIp IN ($ip)");
                } else {
                    $items = $this->FlowsAggByDstIp->getAll("DstPorts REGEXP '(^$dport\$|^$dport,|,$dport,|,$dport\$)'");
                }
                $res[$trace] = $items;
                $rescount += count($items);
            }
            $this->set('res', $res);
            $this->set('rescount', $rescount);
        }
        $this->set('query', $q);
    }

    function graphviz($trace, $dstIp, $dstPort) {
        $this->_initTrace($trace);

        $this->set('dstIp', $dstIp);
        $this->set('dstPort', $dstPort);
    }

    function simpleGraph($trace, $dstIp, $dstPort, $orderType = 'flows') {
        /* NOTE: if you use a different number of packets than 10, you will
        need to change the following line to reflect your settings */
        $ncMarks = array('NC-10', 'NC+10');
        /* NOTE: these are the pattern names used to draw the graph. You can
        change this line as needed */
        $classMarks = array('edonkey', 'bittorrent', 'gnutella', 'ares',
            'directconnect', 'fasttrack', 'napster');
        
        $this->_initTrace($trace);

        $this->set('dstIp', $dstIp);
        $this->set('dstPort', $dstPort);

        $c = 5;
        if (isset($_GET['c']))
            $c = intval($_GET['c']);

        $format = 'svg';
        if (isset($_GET['format']))
            $format = $_GET['format'];
        $this->set('format', $format);

        switch ($orderType) {
        case 'flows':
            $order = 'Flows';
            break;
        case 'mark':
            $order = "COUNT(L7Mark NOT IN ('".$ncMarks[0]."', '".$ncMarks[1]."'))";
            break;
        }
        $srcIps = $this->Flow->getDistinctSrcIps($dstIp, $dstPort, null, null,
            $order);
        //debug($srcIps);
        if (count($srcIps) > $c) {
            $otherSrcIps = array_splice($srcIps, $c - 1);
            $flows = 0;
            foreach ($otherSrcIps as $r) {
                $flows += $r[0]['Flows'];
            }
            $other = array('Hosts' => count($otherSrcIps), 'Flows' => $flows);
            //debug($other);
            $this->set('other', $other);
        }
        $l7Marks = array();
        foreach ($srcIps as &$r) {
            // find breakdown of flows from $r['Flow']['SrcIp'] to $dstIp
            $srcIp = long2ip($r['Flow']['SrcIp']);
            $bd = $this->Flow->getL7MarkBreakdownTo($dstIp,
                $dstPort, $srcIp);
            $r[0]['Breakdown'] = $bd;
            foreach ($bd as $m) {
                $l7Mark = $m['Flow']['L7Mark'];
                if (in_array($l7Mark, $ncMarks))
                    continue;
                if (isset($l7Marks[$l7Mark])) {
                    $l7Marks[$l7Mark] += $m[0]['count'];
                } else {
                    $l7Marks[$l7Mark] = $m[0]['count'];
                }
            }
        }
        //debug($l7Marks);
        $relevantMarks = array_keys($l7Marks);
        $relevantMarks = array_merge($relevantMarks, $classMarks);
        //debug($relevantMarks);
        foreach ($srcIps as &$r) {
            $srcIp = long2ip($r['Flow']['SrcIp']);
            $worthDsts = $this->FlowsAggByDstIpPort->findWorthForSrcIp($srcIp,
                $relevantMarks, $dstIp);
            $r[0]['WorthDsts'] = $worthDsts;
        }
        //debug($srcIps);
        $this->set('srcIps', $srcIps);
        Configure::write('debug', false);
        $this->render('simpleGraph', 'graphviz');
    }


    function _logVerify($trace, $srcIp, $srcPort, $dstIp, $dstPort, $ipProto,
                        $gtProto, $gtApp) {
        $data['VerificationLog']['Event'] = 'verifies';
        $data['VerificationLog']['GtProto'] = $gtProto;
        $data['VerificationLog']['GtApp'] = $gtApp;
        return $this->_log($trace, $srcIp, $srcPort, $dstIp, $dstPort, $ipProto, $data);
    }

    function _logQuesion($trace, $srcIp, $srcPort, $dstIp, $dstPort, $ipProto) {
        $data['VerificationLog']['Event'] = 'questions';
        return $this->_log($trace, $srcIp, $srcPort, $dstIp, $dstPort, $ipProto, $data);
    }

    function _log($trace, $srcIp, $srcPort, $dstIp, $dstPort, $ipProto, $data) {
        $data['VerificationLog']['User'] = $_SERVER['PHP_AUTH_USER'];
        $data['VerificationLog']['Trace'] = $trace;
        if (!empty($srcIp))
            $data['VerificationLog']['SrcIp'] = $srcIp;
        if (!empty($srcPort))
            $data['VerificationLog']['SrcPort'] = $srcPort;
        $data['VerificationLog']['DstIp'] = $dstIp;
        if (!empty($dstPort))
            $data['VerificationLog']['DstPort'] = $dstPort;
        return $this->VerificationLog->save($data);
    }

}

?>
