<?php

class HostNamesController extends AppController
{
    var $name = 'HostNames';
    var $components = array();
    var $helpers = array('Html', 'Ajax');
    var $uses = array('HostName', 'Trace');

    function index() {
        $traces = $this->Trace->findAll();
        foreach ($traces as $trace) {
            $name = $trace['Trace']['Name'];
            $traceOpts[$name] = $name;
        }
        $this->set('traces', $traceOpts);
    }

    function search() {
        if (!empty($this->params['data'])) {
            $trace = $this->params['data']['Trace']['Name'];
            $this->HostName->setTrace($trace);
            $ip = $this->params['data']['HostName']['Ip'];
            $hostname = $this->HostName->find("Ip = INET_ATON('$ip')");
            $this->set('trace', $trace);
            $this->set('hostname', $hostname);
            $this->render('search', 'ajax');
        } else {
            debug($this->params);
            exit(); 
        }
    }

    function update($trace, $ip) {
        if (!empty($this->params['data'])) {
            $this->HostName->setTrace($trace);
            $this->HostName->id = sprintf("%u", ip2long($ip));
            $this->HostName->save($this->params['data']);
            $this->render('update', 'ajax');
        }
    }

}

?>
