#!/bin/sh
if [ ! -f abcd1.sh ]; then
  echo "Please execute this script from its base directory" 1>&2
  exit 1
fi

PATH=../mon2/bin:../gtvs/tools:$PATH

export TRACES_REPOS=../traces
DATASET=abcd/1

export RESULTS=../results

DB_NAME=GTVS
DB_USER=root
DB_PASS=
DB_HOST=localhost
DB_TRACE=abcd1
DB_TABLE=${DB_TRACE}_Flows
export DB_NAME DB_USER DB_PASS DB_HOST DB_TABLE

REAP=60
TCP_TIMEOUT=600
TCP_DONE_TIMEOUT=15
UDP_TIMEOUT=600
export REAP TCP_TIMEOUT TCP_DONE_TIMEOUT UDP_TIMEOUT

PATTERNS_DIR=../mon2/etc/l7-protocols
MAX_PKTS=10
MAX_BYTES=4096
export PATTERNS_DIR MAX_PKTS MAX_BYTES

MYSQL_FLAGS="-h $DB_HOST -u $DB_USER -p$DB_PASS $DB_NAME"

TAG=release
run-click $DATASET gtvs $TAG
if [ "$?" != "0" ]; then
  exit 1
fi

mysql $MYSQL_FLAGS < $RESULTS/$DATASET/click/gtvs/$TAG/flowsinfo.sql

create-agg $DB_TRACE | mysql $MYSQL_FLAGS
create-hn $DB_TRACE | mysql $MYSQL_FLAGS
add-trace $DB_TRACE $TRACES_REPOS/$DATASET | mysql $MYSQL_FLAGS

