#!/bin/sh
set -e
if [ ! -f click.sh ]; then
  echo "Please execute this script from its base directory" 1>&2
  exit 1
fi
BASEDIR=`pwd`

#CLICK_VER=1.6.0
CLICK_VER=1.7.0rc1
#CLICK_VER=git

if [ "$1" = "release" ]; then
  BUILD_TYPE=release
else
  BUILD_TYPE=debug
fi
shift;

BUILD_ARCH=`uname -m`

if [ ! -d click-$CLICK_VER ]; then
  if [ "$CLICK_VER" != "git" ]; then
    wget http://read.cs.ucla.edu/click/click-$CLICK_VER.tar.gz
    tar xzf click-$CLICK_VER.tar.gz
  else
    git clone git://read.cs.ucla.edu/git/click click-$CLICK_VER
  fi
fi


if [ $BUILD_TYPE = "debug" ]; then
  CXXFLAGS="-g -O0 -Wall -pipe"
  CFLAGS="$CXXFLAGS"
else
  if [ "$ARCH" != "" ]; then
    ARCH="-march=$ARCH"
  fi
  CXXFLAGS="-O2 $ARCH -pipe"
  CFLAGS="$CXXFLAGS"
fi
export CXXFLAGS CFLAGS

cd click-$CLICK_VER
./configure --enable-analysis --disable-linuxmodule --prefix=$BASEDIR/mon2/$BUILD_ARCH/$BUILD_TYPE
make
make install
cd ..

cd tnt
./configure --disable-linuxmodule --with-click=$BASEDIR/mon2/$BUILD_ARCH/$BUILD_TYPE $@
make
make install
cd ..

