/*
 * Decompiled with CFR 0.152.
 */
package it.unige.dist.tnt.gtvs;

import it.unige.dist.tnt.gtvs.DnsJavaResolver;
import it.unige.dist.tnt.gtvs.ResolverListener;
import it.unige.dist.tnt.sql.ConnectionFactory;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public final class GtvsResolve
implements ResolverListener {
    Logger log = Logger.getLogger(GtvsResolve.class.getName());
    @Option(name="-h", usage="MySQL hostname")
    private String hostname = "localhost";
    @Option(name="-u", usage="MySQL username")
    private String username = "root";
    @Option(name="-p", usage="MySQL password")
    private String password = "";
    @Option(name="-d", usage="MySQL database")
    private String dbname = "GTVS";
    @Argument
    private List<String> arguments = new ArrayList<String>();
    private static final int NUM_THREADS = 30;
    private static final int NUM_HOSTS = 3000;
    private Connection conn;
    private String curTable;
    private long resolved;

    private GtvsResolve() {
    }

    public void run(String[] stringArray) {
        CmdLineParser cmdLineParser = new CmdLineParser((Object)this);
        String string = null;
        try {
            cmdLineParser.parseArgument(stringArray);
            if (this.arguments.isEmpty()) {
                throw new CmdLineException("Expecting table name");
            }
            string = this.arguments.get(0);
        }
        catch (CmdLineException cmdLineException) {
            System.err.println(cmdLineException.getMessage());
            System.err.println("java " + this.getClass().getName() + " [options...] <table name>");
            cmdLineParser.printUsage((OutputStream)System.err);
            System.err.println();
            System.exit(1);
        }
        try {
            this.conn = ConnectionFactory.getMySQLConnection(this.hostname, this.dbname, this.username, this.password);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            System.exit(1);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            System.exit(1);
        }
        try {
            this.log.info("Will resolve IPs for table " + string + ".");
            long l = System.currentTimeMillis();
            this.resolveTable(string);
            long l2 = (System.currentTimeMillis() - l) / 1000L;
            this.log.info("Resolved " + this.resolved + " IPs in " + l2 + " seconds.");
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            System.exit(1);
        }
    }

    private void resolveTable(String string) throws SQLException {
        this.curTable = string;
        Statement statement = this.conn.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT COUNT(*) FROM " + string + " WHERE HostName IS NULL");
        resultSet.next();
        int n = resultSet.getInt(1);
        resultSet.close();
        this.log.info("Will attempt to resolve " + n + " addresses.");
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(30, 30, 0L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), new ThreadPoolExecutor.CallerRunsPolicy());
        threadPoolExecutor.prestartAllCoreThreads();
        for (int i = 0; i < n; i += 3000) {
            resultSet = statement.executeQuery("SELECT INET_NTOA(Ip), HostName FROM " + string + " LIMIT " + i + ", " + 3000);
            while (resultSet.next()) {
                if (resultSet.getString(2) != null) continue;
                String string2 = resultSet.getString(1);
                threadPoolExecutor.submit(new DnsJavaResolver(string2, this));
            }
            resultSet.close();
        }
        threadPoolExecutor.shutdown();
    }

    @Override
    public void notifyResolution(String string, String string2) {
        try {
            Statement statement = this.conn.createStatement();
            statement.execute("UPDATE " + this.curTable + " SET HostName = '" + string2 + "' WHERE Ip = INET_ATON('" + string + "')");
            this.incrementResolved();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    private synchronized void incrementResolved() {
        ++this.resolved;
    }

    public static void main(String[] stringArray) {
        new GtvsResolve().run(stringArray);
    }
}

