/*
 * Decompiled with CFR 0.152.
 */
package it.unige.dist.tnt.gtvs;

import it.unige.dist.tnt.gtvs.ResolverListener;
import java.net.UnknownHostException;
import java.util.logging.Logger;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Record;
import org.xbill.DNS.ReverseMap;

public class DnsJavaResolver
implements Runnable {
    private String address;
    private ResolverListener listener;
    Logger log = Logger.getLogger(DnsJavaResolver.class.getName());

    public DnsJavaResolver(String string, ResolverListener resolverListener) {
        this.address = string;
        this.listener = resolverListener;
    }

    @Override
    public void run() {
        try {
            Lookup lookup = new Lookup(ReverseMap.fromAddress((String)this.address, (int)1), 12);
            lookup.run();
            if (lookup.getResult() == 0) {
                Record[] recordArray = lookup.getAnswers();
                if (recordArray.length == 1) {
                    String string = recordArray[0].rdataToString();
                    string = string.substring(0, string.length() - 1);
                    this.log.info("Address resolved: " + this.address + ": " + string);
                    this.listener.notifyResolution(this.address, string);
                } else {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = 0; i < recordArray.length; ++i) {
                        String string = recordArray[i].rdataToString();
                        string = string.substring(0, string.length() - 1);
                        this.log.info("Multiple answers: " + this.address + ": " + string);
                        if (i > 0) {
                            stringBuffer.append(' ');
                        }
                        stringBuffer.append(string);
                    }
                    this.listener.notifyResolution(this.address, stringBuffer.toString());
                }
            }
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
        }
    }
}

