require 'logger'

class MyProc
  attr_accessor :pid, :cmd, :lUserCpu, :lSysCpu, :ppid, :startTime, :samples
  
  def initialize(pid, cmd)
    @pid = pid
    @cmd = cmd
    @samples = []
    @lUserCpu = @lSysCpu = nil
  end
  
end

class ProcPsParser
  MAX_SAMPLE_DIFF = 6000
  
  def ProcPsParser.parseLog(is)
    line = is.gets
    lastUptime = nil
    numSamples = 0
    startTime = nil
    ltime = nil
    processMap = {}
    samples = []
    cpus = []
    while line != nil
      while line != nil && line.strip.length == 0
        line = is.gets
      end
      if line == nil
        break
      end
      line.strip!
      # sample start with a timestamp
      if line =~ /^\d+$/
        uptime = 10 * line.to_i # millisecs
        if lastUptime != nil && (uptime < lastUptime || uptime - lastUptime > MAX_SAMPLE_DIFF)
          $log.warn "Invalid uptime: " + uptime.to_s + ", ignoring sample"
          line = is.gets
          next
        end
        numSamples += 1
        #time = Time.at(uptime / 1000, (uptime % 1000) * 1000)
        time = uptime
        if startTime == nil
          startTime = time
        end
      else
        line = is.gets
        next
      end
      
      line = is.gets
      while line != nil && line.strip.length > 0
        line.strip!
        data = line.split(' ')
        pid = data[0].to_i
        if pid == 0
          $log.warn "Invalid line: " + line
          line = is.gets
          next
        end
        cmd = data[1]
        
        proc = processMap[pid];
        if proc == nil
          ppid = data[3].to_i
          proc = MyProc.new(pid, cmd)
          proc.ppid = ppid
          ptime = 10 * data[21].to_i
          #proc.startTime = Time.at(ptime / 1000, (ptime % 1000) * 1000)
          proc.startTime = ptime
          processMap[pid] = proc
        end
        
        userCpu = data[13].to_i;
        sysCpu = data[14].to_i;
        #p userCpu
        #p sysCpu
        cpuLoad = 0.0;
        lUserCpu = proc.lUserCpu
        lSysCpu = proc.lSysCpu
        if lUserCpu != nil && lSysCpu != nil && ltime != nil
          interval = (time - ltime).to_f
          # cpuLoad per sec
          numCpus = 4
          userCpuLoad = (userCpu - lUserCpu).to_f * 10.0 / interval / numCpus
          sysCpuLoad = (sysCpu - lSysCpu).to_f * 10.0 / interval / numCpus
          cpuLoad = userCpuLoad + sysCpuLoad
          cpu = data[38].to_i
          # normalize
          if cpuLoad > 1.0
            $log.warn "cpuLoad: " + cpuLoad.to_s
            userCpuLoad /= cpuLoad
            sysCpuLoad /= cpuLoad
          end
          if samples.size < (numSamples - 1)
            samples << [(time - startTime) / 1000, userCpuLoad, sysCpuLoad, cpuLoad]
            a = [0, 0, 0, 0]
            a[cpu] = cpuLoad * numCpus
            cpus << a
          else
            s = samples[numSamples - 2]
            s[1] += userCpuLoad
            s[2] += sysCpuLoad
            s[3] += cpuLoad
            a = cpus[numSamples - 2]
            a[cpu] += cpuLoad * numCpus
          end
        end        
        proc.lUserCpu = userCpu
        proc.lSysCpu = sysCpu
        line = is.gets
      end
      ltime = time
    end
    return samples, cpus
  end
end

$log = Logger.new($stderr)

f = File.new(ARGV[0], "r")
samples, cpus = ProcPsParser.parseLog(f)

puts "# time, usr load, sys load, usr+sys load, cpu0, cpu1, cpu2, cpu3"
i = 0
samples.each {|s|
  a = cpus[i]
  puts "#{s[0]} #{s[1]} #{s[2]} #{s[3]} #{a[0]} #{a[1]} #{a[2]} #{a[3]}"
  i += 1
}