#ifndef CLICK_SIMPLEAPPFILTER
#define CLICK_SIMPLEAPPFILTER

#include <click/element.hh>
#include <click/vector.hh>

#include "appmark.hh"

CLICK_DECLS

/*
 * SimpleAppFilter filters packets using the APPMARK annotation.
 * This element should borrow a lot from IPClassifier and alike.
 */

class SimpleAppFilter: public Element
{
public:
    SimpleAppFilter(): anyp_(-1) {}
    ~SimpleAppFilter() {}
    
    const char* class_name() const { return "SimpleAppFilter"; }
    const char* port_count() const { return "1/-"; }
    const char* processing() const { return PUSH;  }
    
    int configure(Vector<String> &conf, ErrorHandler *errh);
    void push(int, Packet* p);
private:
    Vector<AppMark> flts_;
    int anyp_; // any packet output port
};

CLICK_ENDDECLS

#endif
