/*
 * simpleappfilter.{cc,hh} -- filter packets using the APPMARK annotation
 *
 * Marco Canini
 *
 * Copyright (c) 2008-09 by University of Genova - DIST - TNT laboratory
 *
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the following
 * conditions are met:
 *
 * * Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in
 *   the documentation and/or other materials provided with the distribution.
 * * Neither the name of University of Genova nor the names of its contributors
 *   may be used to endorse or promote products derived from this software
 *   without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: simpleappfilter.cc 2577 2009-10-05 10:14:43Z marco $
 */

#include <click/config.h>
#include <click/error.hh>

#include "simpleappfilter.hh"
#include "appmarks.hh"

CLICK_DECLS

int SimpleAppFilter::configure(Vector<String> &conf, ErrorHandler *errh)
{
    int before_nerrors = errh->nerrors();
    AppMark mark;
      
    for (int argno = 0; argno < conf.size(); argno++) {
        // check for "-", "any", "all"
        if (conf[argno] == "-" || conf[argno] == "any" || conf[argno] == "all") {
            anyp_ = argno;
            if (argno != conf.size() - 1)
                errh->error("argument %s must appear last", conf[argno].c_str());
            continue;
        }
        mark = AppMarks::default_instance()->lookup(conf[argno]);
        if (mark == AppMarks::empty_mark) {
            errh->error("empty mark %s", conf[argno].c_str());
            continue;
        }
        flts_.push_back(mark);
    }
      
    if (noutputs() != flts_.size() + (anyp_ != -1) ? 1 : 0) {
        return errh->error("number of arguments (%d) must match number of ports (%d)",
            flts_.size(), noutputs());
    }
  
    return (errh->nerrors() == before_nerrors ? 0 : -1);
}

void SimpleAppFilter::push(int, Packet* p)
{
    AppMark m(APPMARK_ANNO(p));
    for (int i = 0; i < flts_.size(); ++i) {
        if (flts_[i].matches(m)) {
            output(i).push(p);
            return;
        }
    }
    if (anyp_ != -1) {
        output(anyp_).push(p);
        return;
    }
    p->kill();
}

ELEMENT_REQUIRES(AppMarks)
EXPORT_ELEMENT(SimpleAppFilter)

#include <click/vector.cc>

CLICK_ENDDECLS
