#ifndef CLICK_SETAPP_HH
#define CLICK_SETAPP_HH

#include <click/element.hh>
#include <click/vector.hh>

#include "flowcache.hh"
#include "appmark.hh"
#include "flowclassifier.hh"

CLICK_DECLS

/*
 * SetApp sets packet APPMARK annotation according to a FlowClassifier.
 */

class SetApp: public Element
{
public:
    SetApp(): flow_cls_(0) {}
    ~SetApp() {}
    
    const char* class_name() const { return "SetApp"; }
    const char* port_count() const { return PORTS_1_1; }
    const char* processing() const { return AGNOSTIC;  }
    
    int configure(Vector<String> &, ErrorHandler *);
    Packet *simple_action(Packet *);
private:
    FlowCache* flow_cache_;
    FlowClassifier* flow_cls_;
};

CLICK_ENDDECLS

#endif
