/*
 * setapp.{cc,hh} -- set packet APPMARK annotation according to a FlowClassifier
 *
 * Marco Canini
 *
 * Copyright (c) 2008-09 by University of Genova - DIST - TNT laboratory
 *
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the following
 * conditions are met:
 *
 * * Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in
 *   the documentation and/or other materials provided with the distribution.
 * * Neither the name of University of Genova nor the names of its contributors
 *   may be used to endorse or promote products derived from this software
 *   without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: setapp.cc 2577 2009-10-05 10:14:43Z marco $
 */

#include <click/config.h>
#include <click/error.hh>
#include <click/confparse.hh>

#include "setapp.hh"

CLICK_DECLS

int SetApp::configure(Vector<String>& conf, ErrorHandler* errh)
{
    Element* af_element = 0;

    if (cp_va_kparse(conf, this, errh,
            "FLOWCLASSIFIER", cpkM, cpElement, &af_element,
            cpEnd) < 0)
        return -1;

    if (af_element && !(flow_cls_ = (FlowClassifier*)(af_element->cast("FlowClassifier"))))
        return errh->error("FLOWCLASSIFIER must be a FlowClassifier element");

    if (!flow_cls_)
        return errh->error("Initialization failure: "
            "missing reference to a FlowClassifier element");

    flow_cache_ = FlowCache::upstream_instance(this);

    if (!flow_cache_)
        return errh->error("Initialization failure: "
            "missing reference to a FlowCache element");

    return 0;
}

Packet* SetApp::simple_action(Packet* p)
{
    FlowClassifier::FlowState* fs;
    fs = flow_cache_->lookup_state<FlowClassifier::FlowState>(flow_cls_, p);
    if (fs) {
        SET_APPMARK_ANNO(p, fs->get_mark());
    } else {
        SET_APPMARK_ANNO(p, AppMarks::empty_mark.get_mark());
    }

    return p;
}

ELEMENT_REQUIRES(FlowCache FlowClassifier)
EXPORT_ELEMENT(SetApp)

#include <click/vector.cc>

CLICK_ENDDECLS
