/*
 * netfpga.{cc,hh} -- NetFPGA controller interface
 *
 * Marco Canini
 *
 * Copyright (c) 2008-09 by University of Genova - DIST - TNT laboratory
 *
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the following
 * conditions are met:
 *
 * * Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in
 *   the documentation and/or other materials provided with the distribution.
 * * Neither the name of University of Genova nor the names of its contributors
 *   may be used to endorse or promote products derived from this software
 *   without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: netfpga.cc 2579 2009-10-05 10:39:18Z marco $
 */

#include <click/config.h>

#include "netfpga.hh"

CLICK_DECLS

NetFPGA* NetFPGA::_instance;

const char * NetFPGA::interfaces[] = {"PHY0", "SW0", "PHY1", "SW1", "PHY2", "SW2", "PHY3", "SW3"};

NetFPGA::NetFPGA()
{
    nf2.device_name = DEFAULT_IFACE;

    if (check_iface(&nf2) < 0) {
        click_chatter("NetFPGA check_iface failed.");
        exit(1);
    }
    if (openDescriptor(&nf2) < 0) {
        click_chatter("NetFPGA openDescriptor failed.");
        exit(1);
    }

    setCutOffThreshold(6);

    NetFPGA::_instance = this;
}

NetFPGA::~NetFPGA ()
{
    closeDescriptor(&nf2);
}

CLICK_ENDDECLS
EXPORT_ELEMENT(NetFPGA)

