#ifndef CLICK_FLOWSCLASSIFIER_HH
#define CLICK_FLOWSCLASSIFIER_HH

#include "dumpflowsinfo2.hh"

CLICK_DECLS

class FlowsClassifier
{
public:
	FlowsClassifier() { }
	virtual ~FlowsClassifier() { }
protected:
	void mark_flow(Packet *p, uint32_t c);
private:
	void set_mark_idx(int mark_idx);

	int _mark_idx;

	friend class DumpFlowsInfo2;
};

inline void FlowsClassifier::mark_flow(Packet *p, uint32_t c)
{
	p->set_user_anno_u(_mark_idx, c);
}

inline void FlowsClassifier::set_mark_idx(int mark_idx)
{
	_mark_idx = mark_idx;
}

CLICK_ENDDECLS

#endif
