/*
 * fileexport.{cc,hh} -- export data records to file
 *
 * Sergio Mangialardi
 * Marco Canini
 *
 * Copyright (c) 2008-09 by University of Genova - DIST - TNT laboratory
 *
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the following
 * conditions are met:
 *
 * * Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in
 *   the documentation and/or other materials provided with the distribution.
 * * Neither the name of University of Genova nor the names of its contributors
 *   may be used to endorse or promote products derived from this software
 *   without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: fileexport.cc 2577 2009-10-05 10:14:43Z marco $
 */

#include <click/config.h>
#include <click/error.hh>
#include <click/confparse.hh>

#include <iostream>
#include <fstream>

#include "fileexport.hh"

CLICK_DECLS

FileExport::~FileExport()
{
	if (os_ != &std::cout)
		delete os_;
}

void* FileExport::cast(const char* n)
{
    if (strcmp(n, "FileExport") == 0)
        return static_cast<FileExport*>(this);
    else if (strcmp(n, "DataExport") == 0)
        return static_cast<DataExport*>(this);
    else
        return Element::cast(n);
}

int FileExport::configure(Vector<String>& conf, ErrorHandler* errh)
{
    Element* next = 0;

    if (cp_va_kparse(conf, this, errh,
            "FILENAME", cpkP+cpkM, cpFilename, &filename_,
            "NEXT", cpkP, cpElement, &next,
            cpEnd) < 0)
        return -1;

    if (next && !(next_ = static_cast<DataExport*>(next->cast("DataExport"))))
        return errh->error("NEXT must be a DataExport element");

    if (filename_ == "-")
        os_ = &std::cout;
    else
        os_ = new std::ofstream(filename_.c_str());

    if (!os_)
        return errh->error("Unable to open file %s", filename_.c_str());

    return 0;
}

void FileExport::add_column(const Column& col)
{
    *os_ << col.name.c_str() << " ";
}

void FileExport::write(const String& val)
{
    *os_ << val.c_str() << " ";
}

void FileExport::write_null()
{
    *os_ << "\\N ";
}

void FileExport::done()
{
    *os_ << std::endl;
}

ELEMENT_REQUIRES(userlevel)
EXPORT_ELEMENT(FileExport)

CLICK_ENDDECLS

