/* ****************************************************************************
 * vim:set shiftwidth=2 softtabstop=2 expandtab:
 * $Id$
 *
 * Module:  reset-counters.c
 * Project: NetFPGA NIC
 * Description: resets the MAC Rx/Tx counters to stdout
 * Author: Marco Canini
 *
 * Change history:
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include <net/if.h>

#include "reg_defines.h"
#include "nf2.h"
#include "nf2util.h"

#define PATHLEN		80

#define DEFAULT_IFACE	"nf2c0"

/* Global vars */
static struct nf2device nf2;

/* Function declarations */
void dumpCounts();
void processArgs (int , char **);
void usage (void);

int main(int argc, char *argv[])
{
  nf2.device_name = DEFAULT_IFACE;

  processArgs(argc, argv);

  // Open the interface if possible
  if (check_iface(&nf2))
    {
      exit(1);
    }
  if (openDescriptor(&nf2))
    {
      exit(1);
    }

  dumpCounts();

  closeDescriptor(&nf2);

  return 0;
}

void dumpCounts()
{
  unsigned val = 0;
  
  writeReg(&nf2, RX_QUEUE_0_NUM_PKTS_STORED_REG, val);
  writeReg(&nf2, RX_QUEUE_0_NUM_PKTS_DROPPED_FULL_REG, val);
  writeReg(&nf2, RX_QUEUE_0_NUM_PKTS_DROPPED_BAD_REG, val);
  writeReg(&nf2, RX_QUEUE_0_NUM_BYTES_PUSHED_REG, val);
  writeReg(&nf2, TX_QUEUE_0_NUM_PKTS_SENT_REG, val);
  writeReg(&nf2, TX_QUEUE_0_NUM_BYTES_PUSHED_REG, val);

  writeReg(&nf2, RX_QUEUE_1_NUM_PKTS_STORED_REG, val);
  writeReg(&nf2, RX_QUEUE_1_NUM_PKTS_DROPPED_FULL_REG, val);
  writeReg(&nf2, RX_QUEUE_1_NUM_PKTS_DROPPED_BAD_REG, val);
  writeReg(&nf2, RX_QUEUE_1_NUM_BYTES_PUSHED_REG, val);
  writeReg(&nf2, TX_QUEUE_1_NUM_PKTS_SENT_REG, val);
  writeReg(&nf2, TX_QUEUE_1_NUM_BYTES_PUSHED_REG, val);

  writeReg(&nf2, RX_QUEUE_2_NUM_PKTS_STORED_REG, val);
  writeReg(&nf2, RX_QUEUE_2_NUM_PKTS_DROPPED_FULL_REG, val);
  writeReg(&nf2, RX_QUEUE_2_NUM_PKTS_DROPPED_BAD_REG, val);
  writeReg(&nf2, RX_QUEUE_2_NUM_BYTES_PUSHED_REG, val);
  writeReg(&nf2, TX_QUEUE_2_NUM_PKTS_SENT_REG, val);
  writeReg(&nf2, TX_QUEUE_2_NUM_BYTES_PUSHED_REG, val);

  writeReg(&nf2, RX_QUEUE_3_NUM_PKTS_STORED_REG, val);
  writeReg(&nf2, RX_QUEUE_3_NUM_PKTS_DROPPED_FULL_REG, val);
  writeReg(&nf2, RX_QUEUE_3_NUM_PKTS_DROPPED_BAD_REG, val);
  writeReg(&nf2, RX_QUEUE_3_NUM_BYTES_PUSHED_REG, val);
  writeReg(&nf2, TX_QUEUE_3_NUM_PKTS_SENT_REG, val);
  writeReg(&nf2, TX_QUEUE_3_NUM_BYTES_PUSHED_REG, val);
}  

/* 
 *  Process the arguments.
 */
void processArgs (int argc, char **argv )
{
  char c;

  /* don't want getopt to moan - I can do that just fine thanks! */
  opterr = 0;
	  
  while ((c = getopt (argc, argv, "i:h")) != -1)
    {
      switch (c)
	{
	case 'i':	/* interface name */
	  nf2.device_name = optarg;
	  break;
	case '?':
	  if (isprint (optopt))
	    fprintf (stderr, "Unknown option `-%c'.\n", optopt);
	  else
	    fprintf (stderr,
		     "Unknown option character `\\x%x'.\n",
		     optopt);
	case 'h':
	default:
	  usage();
	  exit(1);
	}
    }
}


/*
 *  Describe usage of this program.
 */
void usage (void)
{
  printf("Usage: ./reset-counters <options> \n\n");
  printf("Options: -i <iface> : interface name (default nf2c0)\n");
  printf("         -h : Print this message and exit.\n");
}
