#!/usr/local/bin/perl -w
# make_pkts.pl
#

use NF2::PacketGen;
use NF2::PacketLib;
use NF21RouterLib;
require "reg_defines.ph";
require "reg_defines_hostfilter.ph";
$delay = '@2us';
$batch = 0;
nf_set_environment( { PORT_MODE => 'PHYSICAL', MAX_PORTS => 4 } );

# use strict AFTER the $delay, $batch and %reg are declared
use strict;
use vars qw($delay $batch %reg);

# Prepare the DMA and enable interrupts
prepare_DMA('@6us');
enable_interrupts(0);

my $length = 100;
my $DA;
my $SA;
my $pkt;

# send and receive 1 via port 1
$delay = '@5us';
my $delay1 = '@2us';
$length = 60;
$DA = "00:11:11:11:11:11";
$SA = "00:22:22:22:22:22";

$pkt = make_IP_pkt($length, $DA, $SA, 64, '192.168.1.1', '192.168.2.1');
substr($pkt, 23 * 3, 2, "11"); # UDP
substr($pkt, 34 * 3, 2, "00"); # UDP
substr($pkt, 35 * 3, 2, "00"); # UDP
substr($pkt, 36 * 3, 2, "00"); # UDP
substr($pkt, 37 * 3, 2, "00"); # UDP

printf "%s\n",$pkt;
nf_packet_in(1, $length, $delay1, $batch,  $pkt);
nf_expected_dma_data(1, $length, $pkt);

nf_packet_in(1, $length, $delay1, $batch,  $pkt);
nf_expected_dma_data(1, $length, $pkt);

nf_packet_in(1, $length, $delay1, $batch,  $pkt);
nf_expected_dma_data(1, $length, $pkt);

nf_packet_in(1, $length, $delay, $batch,  $pkt);
nf_expected_dma_data(1, $length, $pkt);

nf_packet_in(1, $length, $delay, $batch,  $pkt);
nf_expected_dma_data(1, $length, $pkt);

nf_packet_in(1, $length, $delay, $batch,  $pkt);
nf_expected_dma_data(1, $length, $pkt);

nf_packet_in(1, $length, $delay, $batch,  $pkt);
nf_expected_dma_data(1, $length, $pkt);

nf_packet_in(1, $length, $delay, $batch,  $pkt);
nf_expected_dma_data(1, $length, $pkt);

nf_packet_in(1, $length, $delay, $batch,  $pkt);
nf_expected_dma_data(1, $length, $pkt);

nf_packet_in(1, $length, $delay, $batch,  $pkt);
nf_expected_dma_data(1, $length, $pkt);



nf_PCI_write32($delay, 0, FILTER_KEY0_REG(), 0xC0A80201);
nf_PCI_write32($delay, 0, FILTER_KEY1_REG(), 0xC0A80101);
nf_PCI_write32($delay, 0, FILTER_KEY2_REG(), 0x00110000);
nf_PCI_write32($delay, 0, FILTER_KEY3_REG(), 0x00000000);
nf_PCI_write32($delay, 0, FILTER_CMD_REG(), 0x00000000);
nf_PCI_write32($delay, 0, FILTER_WRITE_REG(), 0x1);
nf_PCI_write32($delay, 0, FILTER_WRITE_REG(), 0x0);

nf_packet_in(1, $length, $delay, $batch,  $pkt);
nf_expected_dma_data(1, $length, $pkt);

nf_packet_in(1, $length, $delay, $batch,  $pkt);
nf_expected_dma_data(1, $length, $pkt);

nf_packet_in(1, $length, $delay, $batch,  $pkt);
nf_expected_dma_data(1, $length, $pkt);

nf_packet_in(1, $length, $delay, $batch,  $pkt);
nf_expected_dma_data(1, $length, $pkt);

nf_packet_in(1, $length, $delay, $batch,  $pkt);
nf_expected_dma_data(1, $length, $pkt);


# *********** Finishing Up - need this in all scripts ! ****************************
my $t = nf_write_sim_files();
print  "--- make_pkts.pl: Generated all configuration packets.\n";
printf "--- make_pkts.pl: Last packet enters system at approx %0d microseconds.\n",($t/1000);
if (nf_write_expected_files()) {
  die "Unable to write expected files\n";
}

nf_create_hardware_file('LITTLE_ENDIAN');
nf_write_hardware_file('LITTLE_ENDIAN');
