`timescale 1ns/1ps

module blockram #(
      parameter RAM_ADDR_BITS = 12,
      parameter RAM_WIDTH = 256      //XXX prozatimni nespocitana hodnota
   )
   (
      input                          clka,
      input                          ena,
      input                          wea,
      input [RAM_ADDR_BITS-1:0]      addra,
      input [RAM_WIDTH-1:0]          ina,
      output reg [RAM_WIDTH-1:0]     outa,

      input                          clkb,
      input                          enb,
      input [RAM_ADDR_BITS-1:0]      addrb,
      output reg [RAM_WIDTH-1:0]     outb

      );

   reg [RAM_WIDTH-1:0] ram [(2**RAM_ADDR_BITS)-1:0];

   always @(posedge clka)
      if (ena)
         if (wea)
            ram[addra] <= ina;
         else
            outa <= ram[addra];
     
   always @(posedge clkb)
      if (enb)
         outb <= ram[addrb]; 
endmodule
