
#include <stdlib.h>

#include "/root/NF2-filter_nic/lib/C/common/nf2.h"
#include "/root/NF2-filter_nic/lib/C/common/nf2util.h"
#include "/root/NF2-filter_nic/projects/hostfilter/lib/C/reg_defines_hostfilter.h"


#define CMD_DELETE 0x0
#define CMD_INSERT 0x1
#define CMD_RESET 0x2

#define DEFAULT_IFACE   "nf2c0"


class FilterController {
private:

long long compute_hash (unsigned int ipaddr[], unsigned int port [], unsigned in
t protocol) {
   long long hash = 0;
   long long word0 = 0;
   long long word1 = 0;
   long long word2 = 0;
   long long word3 = 0;
   int i;

   for (i = 0; i < 4; i++) {
      word0 |= (( (ipaddr[0]>> (8 * i))  + (ipaddr[1]>> (8 * i)) ) & 0xFF) << (8
 * i);
   }


   for (i = 0; i < 2; i++) {
      word1 |= (( (ipaddr[1]>> (8 * 2 * i))  + (ipaddr[1]>> (8 * (2 * i + 1))) )
 & 0xFF) << (8 * i);
   }

   for (i = 2; i < 4; i++) {
      word1 |= (( (ipaddr[0]>> (8 * 2 * i))  + (ipaddr[0]>> (8 * (2 * i + 1))) )
 & 0xFF) << (8 * i);
   }

   word2 =
      ( ( (port[0] + protocol) & 0xFFFF) << 16) |
      (    port[1]             & 0xFFFF);


   word3 =
      ( ( (port[0] + (port[0] >> 8) ) & 0xFF) << 24) |
      ( ( (port[1] + (port[1] >> 8) ) & 0xFF) << 16) |
      (   (protocol                   & 0xFF) << 8);

   hash =
      ( (0xFFFFFFFF & (word3 + word1) ) << 32) +
      (  0xFFFFFFFF & (word0 + word2) );

   return hash;
  }



    static struct nf2device nf2;
    
public:
    void FilterController () {
        nf2.device_name = DEFAULT_DEVICE;

        if (check_iface(&nf2)) {
            exit(1);
        }
        if (openDescriptor(&nf2)) {
            exit(1);
        }

    }
    void ~FilterController () {
        closeDescriptor(&nf2);
    }

    bool insertIpPort(uint32_t ipaddr, uint32_t l4port,
                uint8_t protocol, uint8_t route) {

        writeReg(&nf2, HOST_WRITE_REG, 0);
        writeReg(&nf2, HOST_KEY0_REG, ipaddr);
        writeReg(&nf2, HOST_KEY1_REG, (0x0000FFFF & l4port) | ((protocol << 16) & 0x00FF0000 ));
        writeReg(&nf2, HOST_CMD_REG, ((route << 16) 0x000F0000) | CMD_INSERT);
        writeReg(&nf2, HOST_WRITE_REG, 1);
        writeReg(&nf2, HOST_WRITE_REG, 0);

        return 1;
    }

    bool removeIpPort(uint32_t ipaddr, uint32_t l4port, uint8_t protocol) {

        writeReg(&nf2, HOST_WRITE_REG, 0);
        writeReg(&nf2, HOST_KEY0_REG, ipaddr);
        writeReg(&nf2, HOST_KEY1_REG, (0x0000FFFF & l4port) | ((protocol << 16) & 0x00FF0000 ));
        writeReg(&nf2, HOST_CMD_REG, CMD_REMOVE);
        writeReg(&nf2, HOST_WRITE_REG, 1);
        writeReg(&nf2, HOST_WRITE_REG, 0);

        return 1;
    }

    bool insertFlow(uint32_t srcipaddr, uint32_t dstipaddr, uint32_t srcport, uint32_t dstport, uint8_t protocol, uint8_t route) {

        return 0;
    }

    bool resetFlow(uint32_t srcipaddr, uint32_t dstipaddr, uint32_t srcport, uint32_t dstport, uint8_t protocol) {
        return 0;
    }

    bool removeFlow(uint32_t srcipaddr, uint32_t dstipaddr, uint32_t srcport, uint32_t dstport, uint8_t protocol) {
        long long key;
        uint32_t ipaddr[2];
        uint32_t port[2];

        ipaddr[0] = srcipaddr;
        ipaddr[1] = dstipaddr;
        port[0]   = srcport;
        port[1]   = dstport;

        key = compute_hash(ipaddr, port, protocol);
      //  printf("Hash: %x, %llu \n", key, key);


        writeReg(&nf2, FILTER_KEY0_REG, key & 0xFFFFFFFF);
        writeReg(&nf2, FILTER_KEY1_REG, (key >> 32) & 0xFFFFFFFF);
        writeReg(&nf2, FILTER_CMD_REG, CMD_DELETE);
        writeReg(&nf2, FILTER_WRITE_REG, 1);
        writeReg(&nf2, FILTER_WRITE_REG, 0);


        return 1;
    }





    bool classMapping(uint32_t applicationclass, uint32_t route) {
        uint32_t lastrouting;
        uint32_t routing;
        routing = (0xF & route) << (applicationclass*4);
        lastrouting = (~(0xF << (applicationclass*4))) & readReg(&nf2, AR_SW_REG);
        writeReg(&nf2, AR_SW_REG, lastrouting | routing);
        return 1;
    }

};



