/*********** THESE ARE ALL WORD ADDRESSES (note the <<2 when printing external addresses) ***********/

`define HOST_REG_ADDR_WIDTH           `UDP_BLOCK_SIZE_64_REG_ADDR_WIDTH
`define HOST_BLOCK_ADDR_WIDTH         `UDP_BLOCK_SIZE_64_BLOCK_ADDR_WIDTH
`define HOST_BLOCK_ADDR               `HOST_BLOCK_ADDR_WIDTH'hA
`define HOST_BLOCK_TAG                ({`UDP_BLOCK_SIZE_64_TAG, `HOST_BLOCK_ADDR})


`define FILTER_REG_ADDR_WIDTH           `UDP_BLOCK_SIZE_64_REG_ADDR_WIDTH
`define FILTER_BLOCK_ADDR_WIDTH         `UDP_BLOCK_SIZE_64_BLOCK_ADDR_WIDTH
`define FILTER_BLOCK_ADDR               `FILTER_BLOCK_ADDR_WIDTH'hB
`define FILTER_BLOCK_TAG                ({`UDP_BLOCK_SIZE_64_TAG, `FILTER_BLOCK_ADDR})

`define DROP_REG_ADDR_WIDTH           `UDP_BLOCK_SIZE_64_REG_ADDR_WIDTH
`define DROP_BLOCK_ADDR_WIDTH         `UDP_BLOCK_SIZE_64_BLOCK_ADDR_WIDTH
`define DROP_BLOCK_ADDR               `DROP_BLOCK_ADDR_WIDTH'hD
`define DROP_BLOCK_TAG                ({`UDP_BLOCK_SIZE_64_TAG, `DROP_BLOCK_ADDR})


`define AR_REG_ADDR_WIDTH           `UDP_BLOCK_SIZE_64_REG_ADDR_WIDTH
`define AR_BLOCK_ADDR_WIDTH         `UDP_BLOCK_SIZE_64_BLOCK_ADDR_WIDTH
`define AR_BLOCK_ADDR               `AR_BLOCK_ADDR_WIDTH'hC
`define AR_BLOCK_TAG                ({`UDP_BLOCK_SIZE_64_TAG, `AR_BLOCK_ADDR})



/*******************************************************************
 -- Internal addresses -- these are used inside the modules
 *******************************************************************/

`define HOST_KEY0               	`HOST_REG_ADDR_WIDTH'h0
`define HOST_KEY1               	`HOST_REG_ADDR_WIDTH'h1
`define HOST_CMD                        `HOST_REG_ADDR_WIDTH'h2
`define HOST_WRITE                      `HOST_REG_ADDR_WIDTH'h3
`define HOST_RESET                      `HOST_REG_ADDR_WIDTH'h4

`define HOST_NUM_PKTS_LABELED           `HOST_REG_ADDR_WIDTH'h8
`define HOST_NUM_PKTS_NOTLABELED        `HOST_REG_ADDR_WIDTH'h9
`define HOST_ENTRYSTAT                  `HOST_REG_ADDR_WIDTH'hA

`define FILTER_KEY0               	`FILTER_REG_ADDR_WIDTH'h0
`define FILTER_KEY1               	`FILTER_REG_ADDR_WIDTH'h1
`define FILTER_KEY2               	`FILTER_REG_ADDR_WIDTH'h2
`define FILTER_KEY3               	`FILTER_REG_ADDR_WIDTH'h3
`define FILTER_CMD                      `FILTER_REG_ADDR_WIDTH'h4
`define FILTER_WRITE                    `FILTER_REG_ADDR_WIDTH'h5
`define FILTER_CUTOFF                   `FILTER_REG_ADDR_WIDTH'h6
`define FILTER_RESET                    `FILTER_REG_ADDR_WIDTH'h7

`define FILTER_NUM_PKTS_LABELED         `FILTER_REG_ADDR_WIDTH'hB
`define FILTER_NUM_PKTS_NOTLABELED      `FILTER_REG_ADDR_WIDTH'hC

`define AR_SW                           `AR_REG_ADDR_WIDTH'h0
`define AR_SW0_NUM_PKTS                 `AR_REG_ADDR_WIDTH'h1

`define DROP_PIPELINE_STOP              `DROP_REG_ADDR_WIDTH'h0
`define DROP_CNT_ACCEPTED               `DROP_REG_ADDR_WIDTH'h3
`define DROP_CNT_DISCARDED              `DROP_REG_ADDR_WIDTH'h4

/************************
  --- External addresses
 ************************/

`define FILTER_KEY0_REG                      (`UDP_BASE_ADDRESS | {`FILTER_BLOCK_TAG, `FILTER_KEY0})
`define FILTER_KEY1_REG                      (`UDP_BASE_ADDRESS | {`FILTER_BLOCK_TAG, `FILTER_KEY1})
`define FILTER_KEY2_REG                      (`UDP_BASE_ADDRESS | {`FILTER_BLOCK_TAG, `FILTER_KEY2})
`define FILTER_KEY3_REG                      (`UDP_BASE_ADDRESS | {`FILTER_BLOCK_TAG, `FILTER_KEY3})
`define FILTER_CMD_REG                      (`UDP_BASE_ADDRESS | {`FILTER_BLOCK_TAG, `FILTER_CMD})
`define FILTER_WRITE_REG                      (`UDP_BASE_ADDRESS | {`FILTER_BLOCK_TAG, `FILTER_WRITE})
`define FILTER_CUTOFF_REG                      (`UDP_BASE_ADDRESS | {`FILTER_BLOCK_TAG, `FILTER_CUTOFF})
`define FILTER_NUM_PKTS_LABELED_REG            (`UDP_BASE_ADDRESS | {`FILTER_BLOCK_TAG, `FILTER_NUM_PKTS_LABELED})
`define FILTER_NUM_PKTS_NOTLABELED_REG            (`UDP_BASE_ADDRESS | {`FILTER_BLOCK_TAG, `FILTER_NUM_PKTS_NOTLABELED})
`define FILTER_RESET_REG                      (`UDP_BASE_ADDRESS | {`FILTER_BLOCK_TAG, `FILTER_RESET})

`define HOST_KEY0_REG                      (`UDP_BASE_ADDRESS | {`HOST_BLOCK_TAG, `HOST_KEY0})
`define HOST_KEY1_REG                      (`UDP_BASE_ADDRESS | {`HOST_BLOCK_TAG, `HOST_KEY1})
`define HOST_CMD_REG                      (`UDP_BASE_ADDRESS | {`HOST_BLOCK_TAG, `HOST_CMD})
`define HOST_WRITE_REG                      (`UDP_BASE_ADDRESS | {`HOST_BLOCK_TAG, `HOST_WRITE})
`define HOST_RESET_REG                      (`UDP_BASE_ADDRESS | {`HOST_BLOCK_TAG, `HOST_RESET})
`define HOST_NUM_PKTS_LABELED_REG                      (`UDP_BASE_ADDRESS | {`HOST_BLOCK_TAG, `HOST_NUM_PKTS_LABELED})
`define HOST_NUM_PKTS_NOTLABELED_REG                      (`UDP_BASE_ADDRESS | {`HOST_BLOCK_TAG, `HOST_NUM_PKTS_NOTLABELED})
`define HOST_ENTRYSTAT_REG                      (`UDP_BASE_ADDRESS | {`HOST_BLOCK_TAG, `HOST_ENTRYSTAT})

`define AR_SW_REG                      (`UDP_BASE_ADDRESS | {`AR_BLOCK_TAG, `AR_SW})
`define AR_SW0_NUM_PKTS_REG                      (`UDP_BASE_ADDRESS | {`AR_BLOCK_TAG, `AR_SW0_NUM_PKTS})

`define DROP_PIPELINE_STOP_REG                      (`UDP_BASE_ADDRESS | {`DROP_BLOCK_TAG, `DROP_PIPELINE_STOP})
`define DROP_CNT_ACCEPTED_REG                      (`UDP_BASE_ADDRESS | {`DROP_BLOCK_TAG, `DROP_CNT_ACCEPTED})
`define DROP_CNT_DISCARDED_REG                      (`UDP_BASE_ADDRESS | {`DROP_BLOCK_TAG, `DROP_CNT_DISCARDED})

/************************
  --- Print the registers
 ************************/
`define PRINT_USER_REG_ADDRESSES                                                                                                                   \
    $fwrite(c_reg_defines_fd, "#define FILTER_KEY0_REG           0x%07x\n\n", `FILTER_KEY0_REG<<2); \
    $fwrite(c_reg_defines_fd, "#define FILTER_KEY1_REG           0x%07x\n\n", `FILTER_KEY1_REG<<2); \
    $fwrite(c_reg_defines_fd, "#define FILTER_KEY2_REG           0x%07x\n\n", `FILTER_KEY2_REG<<2); \
    $fwrite(c_reg_defines_fd, "#define FILTER_KEY3_REG           0x%07x\n\n", `FILTER_KEY3_REG<<2); \
    $fwrite(c_reg_defines_fd, "#define FILTER_CMD_REG            0x%07x\n\n", `FILTER_CMD_REG<<2);  \
    $fwrite(c_reg_defines_fd, "#define FILTER_WRITE_REG          0x%07x\n\n", `FILTER_WRITE_REG<<2);\
    $fwrite(c_reg_defines_fd, "#define FILTER_CUTOFF_REG          0x%07x\n\n", `FILTER_CUTOFF_REG<<2);\
    $fwrite(c_reg_defines_fd, "#define FILTER_RESET_REG          0x%07x\n\n", `FILTER_RESET_REG<<2);\
    $fwrite(c_reg_defines_fd, "#define FILTER_NUM_PKTS_LABELED_REG          0x%07x\n\n", `FILTER_NUM_PKTS_LABELED_REG<<2);\
    $fwrite(c_reg_defines_fd, "#define FILTER_NUM_PKTS_NOTLABELED_REG          0x%07x\n\n", `FILTER_NUM_PKTS_NOTLABELED_REG<<2);\
    $fwrite(c_reg_defines_fd, "#define HOST_KEY0_REG           0x%07x\n\n", `HOST_KEY0_REG<<2); \
    $fwrite(c_reg_defines_fd, "#define HOST_KEY1_REG           0x%07x\n\n", `HOST_KEY1_REG<<2); \
    $fwrite(c_reg_defines_fd, "#define HOST_CMD_REG            0x%07x\n\n", `HOST_CMD_REG<<2);  \
    $fwrite(c_reg_defines_fd, "#define HOST_WRITE_REG          0x%07x\n\n", `HOST_WRITE_REG<<2); \
    $fwrite(c_reg_defines_fd, "#define HOST_RESET_REG          0x%07x\n\n", `HOST_RESET_REG<<2); \
    $fwrite(c_reg_defines_fd, "#define HOST_NUM_PKTS_LABELED_REG          0x%07x\n\n", `HOST_NUM_PKTS_LABELED_REG<<2); \
    $fwrite(c_reg_defines_fd, "#define HOST_NUM_PKTS_NOTLABELED_REG          0x%07x\n\n", `HOST_NUM_PKTS_NOTLABELED_REG<<2); \
    $fwrite(c_reg_defines_fd, "#define HOST_ENTRYSTAT_REG          0x%07x\n\n", `HOST_ENTRYSTAT_REG<<2); \
    $fwrite(c_reg_defines_fd, "#define 	DROP_PIPELINE_STOP_REG          0x%07x\n\n", `DROP_PIPELINE_STOP_REG<<2); \
    $fwrite(c_reg_defines_fd, "#define 	DROP_CNT_ACCEPTED_REG          0x%07x\n\n", `DROP_CNT_ACCEPTED_REG<<2); \
    $fwrite(c_reg_defines_fd, "#define 	DROP_CNT_DISCARDED_REG          0x%07x\n\n", `DROP_CNT_DISCARDED_REG<<2); \
    $fwrite(c_reg_defines_fd, "#define 	AR_SW_REG          0x%07x\n\n", `AR_SW_REG<<2); \
    $fwrite(c_reg_defines_fd, "#define AR_SW0_NUM_PKTS_REG          0x%07x\n\n", `AR_SW0_NUM_PKTS_REG<<2)

