require(atoz);

CrashHandler(gdb);
ControlSocket(TCP, 7777);

NetFPGA;

AppMarks(
WWW::,
MAIL::,
BULK::,
ATTACK::,
CHAT::,
P2P::,
DATABASE::,
MULTIMEDIA::,
VOIP::,
SERVICES::,
INTERACTIVE::,
GAMES::,
GRID::
);

wekacls::Campus_12f_05;
//wekacls::RInst_12f_05;

dev::FromDevice(nf2c0, PROMISC true, SNAPLEN 64, FORCE_IP true, CAPTURE PCAP)->
c::Counter->
StripToNetworkHeader()->
/* If StripToNetworkHeader fails, use */
// Strip(14)->
MarkIPHeader()->
hc::HostCache(SIZE 2048, UP_INTERVAL 60)->
fc::FlowCache(REAP 5, DOTTEDIP true,
    TCP_TIMEOUT 60,
    TCP_DONE_TIMEOUT 5,
    UDP_TIMEOUT 60,
    WRRI 0, STATS 0)->
fe::MLFeatureExtractor()->
MLFlowCls(MLFEATUREEXTRACTOR fe, WEKACLS wekacls)->
FlowClassifier()->
Discard;

Script(
print "stats: # pkt_count byte_count pkt_rate tcp_active_flows udp_active_flows kernel_drops",
label rate_stats,
printn "stats: ",
printn c.count,
printn " ",
printn c.byte_count,
printn " ",
printn c.rate,
printn " ",
printn fc.tcp_active_flows,
printn " ",
printn fc.udp_active_flows,
printn " ",
print dev.kernel_drops,
wait 1s,
goto rate_stats
);

DriverManager(wait, write fc.clear, read fc.next_flow_id,
read c.count,
read c.byte_count,
read dev.kernel_drops,
stop);

