/**
 * Dump Classifier
 */
package netos;

import weka.core.Utils;
import weka.classifiers.trees.J48;
import java.io.ObjectInputStream;
import java.io.FileInputStream;

public class DumpCls {

  private final static String USAGE = "dumpcls -t <model file> -c <class name>";

  public static void main(String[] options) {

    try {
      String modelName = Utils.getOption('t', options);
      if (modelName.length() == 0) {
        System.err.println(USAGE);
        System.exit(1);
      }
      String className = Utils.getOption('c', options);
      if (className.length() == 0) {
        System.err.println(USAGE);
        System.exit(1);
      }

      J48 tree;

      ObjectInputStream modelInObjectFile = 
	  new ObjectInputStream(new FileInputStream(modelName));
      tree = (J48) modelInObjectFile.readObject();
      modelInObjectFile.close();

      System.out.print(tree.toSource(className));
    } catch (Exception e) {
      e.printStackTrace();
      System.exit(1);
    }
  }
}
