/* Various protocol definitions */
struct iphdr {
        uint8_t hlen:4,
                version:4;
	uint8_t tos;
	n16 tot_len;
	n16 id;
	n16 frag_off;
	uint8_t ttl;
	uint8_t protocol;
	n16 check;
	n32 saddr;
	n32 daddr;
};

struct ethhdr {
	unsigned char h_dest[6];
	unsigned char h_src[6];
	n16 h_proto;
};

struct udphdr {
	n16   sport;
	n16   dport;
	n16   len;
	n16   check;
};

struct tcphdr {
        n16   sport;
        n16   dport;
        seqnr_t   seq;
        seqnr_t   ack_seq;
        unsigned   res1:4,
                doff:4,
                fin:1,
                syn:1,
                rst:1,
                psh:1,
                ack:1,
                urg:1,
                ece:1,
                cwr:1;
        n16   window;
        n16   check;
        n16   urg_ptr;
};

struct icmphdr {
	unsigned char type;
	unsigned char code;
	n16 checksum;
};

/* Taken from /usr/include/linux/icmp.h to avoid include hell */
#define ICMP_ECHOREPLY          0       /* Echo Reply                   */
#define ICMP_DEST_UNREACH       3       /* Destination Unreachable      */
#define ICMP_SOURCE_QUENCH      4       /* Source Quench                */
#define ICMP_REDIRECT           5       /* Redirect (change route)      */
#define ICMP_ECHO               8       /* Echo Request                 */
#define ICMP_TIME_EXCEEDED      11      /* Time Exceeded                */
#define ICMP_PARAMETERPROB      12      /* Parameter Problem            */
#define ICMP_TIMESTAMP          13      /* Timestamp Request            */
#define ICMP_TIMESTAMPREPLY     14      /* Timestamp Reply              */
#define ICMP_INFO_REQUEST       15      /* Information Request          */
#define ICMP_INFO_REPLY         16      /* Information Reply            */
#define ICMP_ADDRESS            17      /* Address Mask Request         */
#define ICMP_ADDRESSREPLY       18      /* Address Mask Reply           */



