/* How much memory to use for buffering data before writing it to
   disk. */
#define MAX_BUFFER_MB 32
/* How much buffer to use for each connection, in bytes */
#define PER_CONN_BUFFER 512
/* How many live connections to keep around before starting to time
   them out when the model says not to.  Keep this high if you want
   good results.  Each connection takes about 58 bytes. */
/* The default is 1.5G of live connections. */
#define NR_LIVE_CONNS 26658712

/* How many entries in the hash table */
#define HASH_SIZE 65536

/* Parameters affecting various internal data structures. */

/* Highest possible file descriptor, plus one. */
#define MAX_FDS 4097

/* Don't change these */
#define MAX_BUFFERS ((MAX_BUFFER_MB * 1024 * 1024) / PER_CONN_BUFFER)
