/* A few random utility functions */
#define _GNU_SOURCE
#include <err.h>
#include <printf.h>
#include <stdio.h>
#include <stdlib.h>
#include <netinet/in.h>

#include "demux.h"

unsigned long
__net_to_host(const void *x, unsigned s)
{
	n16 *_n16;
	n32 *_n32;
	switch (s) {
	case 2:
		_n16 = (n16 *)x;
		return ntohs(_n16->a);
	case 4:
		_n32 = (n32 *)x;
		return ntohl(_n32->a);
	default:
		abort();
	}
}

int
cmp_streamid(const struct streamid *sid1, const struct streamid *sid2)
{
	return !(sid1->saddr.a == sid2->saddr.a &&
		 sid1->sport.a == sid2->sport.a &&
		 sid1->daddr.a == sid2->daddr.a &&
		 sid1->dport.a == sid2->dport.a &&
		 sid1->protocol == sid2->protocol);
}

unsigned long
hash_streamid(const struct streamid *sid)
{
	unsigned long h;
	h = (sid->saddr.a ^ sid->daddr.a ^ sid->sport.a ^ sid->dport.a);
	while (h >= HASH_SIZE)
		h = (h / HASH_SIZE) ^ (h % HASH_SIZE);
	return h;
}

int
seq_eq(seqnr_t s1, seqnr_t s2)
{
	return s1.s == s2.s;
}

seqnr_t
seq_plus(seqnr_t s, unsigned long x)
{
	return (seqnr_t){s:htonl(ntohl(s.s) + x)};
}

void *
xcalloc(unsigned s, unsigned n)
{
	void *r;
	r = calloc(s, n);
	if (!r)
		err(1, "out of memory");
	return r;
}

static int
printf_special_D_handler_func(FILE *f, const struct printf_info *info,
			      const void *const *args)
{
	int r;
	struct datagram *dg = *(struct datagram **)args[0];
	r = fprintf(f, "%Q->%Q (id %x)",
		    dg->head_packet->ip->saddr.a,
		    dg->head_packet->ip->daddr.a,
		    dg->head_packet->ip->id.a);
	return r;
}

static int
printf_special_D_arginfo_func(const struct printf_info *info,
                              size_t n,
                              int *argtypes)
{
        if (n > 0)
                argtypes[0] = PA_POINTER;
        return 1;
}

static int
printf_special_Q_handler_func(FILE *f, const struct printf_info *info,
			      const void *const *args)
{
	int r;
	unsigned long addr = *(unsigned long *)args[0];
	unsigned char *a = (unsigned char *)&addr;
	r = fprintf(f, "%ld.%ld.%ld.%ld",
		    (unsigned long)a[0],
		    (unsigned long)a[1],
		    (unsigned long)a[2],
		    (unsigned long)a[3]);
	return r;
}

static int
printf_special_Q_arginfo_func(const struct printf_info *info,
                              size_t n,
                              int *argtypes)
{
        if (n > 0)
                argtypes[0] = PA_FLAG_LONG | PA_INT;
        return 1;
}

static int
printf_special_P_handler_func(FILE *f, const struct printf_info *info,
			      const void *const *args)
{
	int r;
	struct tcpconn *p = *(struct tcpconn **)args[0];
	switch (p->sid.protocol) {
	case IPPROTO_UDP:
	case IPPROTO_TCP:
		r = fprintf(f, "%d/%Q/%.05d/%Q/%.05d/%ld.%.06ld",
			    (int)p->sid.protocol,
			    p->sid.saddr.a,
			    net_to_host(p->sid.sport),
			    p->sid.daddr.a,
			    net_to_host(p->sid.dport),
			    p->start.tv_sec,
			    p->start.tv_usec);
		break;
	default:
		r = fprintf(f, "%d/%Q/%Q/%ld.%.06ld",
			    (int)p->sid.protocol,
			    p->sid.saddr.a,
			    p->sid.daddr.a,
			    p->start.tv_sec,
			    p->start.tv_usec);
		break;
	}
	return r;
}

static int
printf_special_P_arginfo_func(const struct printf_info *info,
                              size_t n,
                              int *argtypes)
{
        if (n > 0)
                argtypes[0] = PA_POINTER;
        return 1;
}

void
register_printf_specials(void)
{
	register_printf_function('P', printf_special_P_handler_func,
                                 printf_special_P_arginfo_func);
	register_printf_function('Q', printf_special_Q_handler_func,
                                 printf_special_Q_arginfo_func);
	register_printf_function('D', printf_special_D_handler_func,
                                 printf_special_D_arginfo_func);
}

struct tee_file_cookie {
	FILE *f1, *f2;
};

static ssize_t
tee_write_func(void *cookie, const char *buffer, size_t size)
{
	struct tee_file_cookie *tfc = cookie;
	return fwrite(buffer, 1, fwrite(buffer, 1, size, tfc->f1), tfc->f2);
}

static int
tee_close_func(void *cookie)
{
	free(cookie);
	return 0;
}

FILE *
open_tee(FILE *f1, FILE *f2)
{
	struct tee_file_cookie *tfc;
	FILE *f;
	tfc = xcalloc(sizeof(*tfc), 1);
	tfc->f1 = f1;
	tfc->f2 = f2;
	f = fopencookie(tfc, "w",
			(cookie_io_functions_t){write:tee_write_func,
						close:tee_close_func});
	if (!f)
		err(1, "openning tee file");
	setvbuf(f, NULL, _IONBF, 0);
	return f;
}
