#include <sys/queue.h>
#include <stdio.h>

#define HASH_SIZE 65536

/* Some simple constructs to make network<->host byte order
   conversions a bit easier and safer. */
typedef struct {
	unsigned long a;
} n32;
typedef struct {
	unsigned short a;
} n16;
#define net_to_host(x) ((__typeof__((x).a))__net_to_host(&(x), sizeof((x).a)))
unsigned long __net_to_host(const void *x, unsigned s);

/* Sequence number wrapper functions */
typedef struct {
	unsigned long s;
} seqnr_t;
int seq_eq(seqnr_t s1, seqnr_t s2);
seqnr_t seq_plus(seqnr_t s, unsigned long x);

/* Stream identifier stuff */
struct streamid {
	n32 saddr;
	n32 daddr;
	n16 sport;
	n16 dport;
	unsigned char protocol;
};
int cmp_streamid(const struct streamid *sid1, const struct streamid *sid2);
unsigned long hash_streamid(const struct streamid *sid);

void *xcalloc(unsigned s, unsigned n);
void register_printf_specials(void);
FILE *open_tee(FILE *f1, FILE *f2);

struct tcpflow {
	seqnr_t fin_seq;
	seqnr_t syn_seq;
	unsigned has_sent_syn:1,
		 has_sent_fin:1,
		 acked_fin:1,
	  	 c2s:1;
	unsigned nr_datagrams;
};

/* This can actually represent udp or icmp flows as well, but those
   are kind of degenerate special cases. */
struct tcpconn {
	struct streamid sid;
	unsigned comatose:1;
	unsigned aborted:1;
	struct tcpflow flow[2];
	int fd;
	LIST_ENTRY(tcpconn) hash_chain;
	TAILQ_ENTRY(tcpconn) lru_chain;
	TAILQ_ENTRY(tcpconn) fd_lru;
	TAILQ_ENTRY(tcpconn) buffer_lru;
	unsigned buffer_used;
	void *buffer;
	struct timeval start, last_datagram;
};

struct iphdr {
        uint8_t hlen:4,
                version:4;
	uint8_t tos;
	n16 tot_len;
	n16 id;
	n16 frag_off;
	uint8_t ttl;
	uint8_t protocol;
	n16 check;
	n32 saddr;
	n32 daddr;
};

/* Packets are threaded on two linked lists, one by time and one by
   offset in the datagram.  Terminology: a packet is a thing we pick
   off of the wire, a datagram is a complete IP datagram (post
   de-fragmentation). */
struct datagram {
	struct datagram *next, **pdg;
	struct streamid sid;
	union {
		const void *ip_payload;
		const struct tcphdr *tcp;
		const struct udphdr *udp;
	};
	unsigned flownr;
	unsigned tcpdata;
	struct packet *first_packet, *last_packet; /* time */
	struct packet *head_packet, *tail_packet; /* offset */
};

struct packet {
	struct packet *next_time, *prev_time, *next_off, *prev_off;
	const struct ethhdr *eth;
	const struct iphdr *ip;
	struct timeval ts;
	unsigned len;
	const void *payload;
};


