/* Can't cope with any packets bigger than this.  This must be a
   factor of the page size. */
#define SK98_EXPECTED_PACKET_SIZE 2048

#define SK98_RING_SIZE 65534
struct sk98_map_area_header {
	/* Stuff mostly written by userspace */
	unsigned k2u_cons;
	unsigned u2k_prod;
	unsigned u2k_tokens[SK98_RING_SIZE];

	/* Stuff mostly written by kernel space */
	unsigned u2k_cons;
	unsigned k2u_prod;
	struct {
		unsigned token;
		unsigned tstamp;
		unsigned short len;
		unsigned short interface;
	} k2u_pipe[SK98_RING_SIZE];

	unsigned drop_counter;
};

struct sk98_ioctl_map {
	void *start_addr;
	unsigned long len;
	unsigned offset;
	unsigned version;
#define SK98_CURRENT_VERSION 4
};
#define SK98_IOCTL_MAP 1

