

#include <sys/param.h>
#include <sys/time.h>
#include <sys/socket.h>

#if __STDC__
struct mbuf;
struct rtentry;
#endif
#include <net/if.h>

#include <netinet/in.h>
#include <netinet/if_ether.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <netinet/ip_var.h>
#include <netinet/udp.h>
#include <netinet/udp_var.h>
#include <netinet/tcp.h>
#include <netinet/tcpip.h>

#include <stdio.h>
#include <pcap.h>

#include "interface.h"
#include "addrtoname.h"
#include "ethertype.h"
#include "if_nprobe.h"
#include "http_errdefs.h"



char *
get_atmaddr(unsigned long atmdata)
{
  static char addr[32];
  unsigned char card = atmdata >> 24;
  unsigned char vpi = (atmdata >> 16) & 0xff;
  unsigned short vci = atmdata & 0xffff;

  sprintf(addr, "%hu.%hu.%hu", 
	  card, vpi, vci);

  return addr;
}

void 
nprobe_if_print(u_char *user, const struct pcap_pkthdr *h, const u_char *p)
{

  nprobe_hdr_t *npp = (nprobe_hdr_t *)p;
  u_int length = h->len;
  u_int caplen = h->caplen;
  int err;
  ts_print(&h->ts);
  printf("(%s) ", get_atmaddr(ntohl(npp->u.nh.atmdata)));

  if (caplen < sizeof(np_hdr_t)) 
    {
      printf("[|nprobe]");
      goto out;
    }

  err = (int)npp->u.nh.code;
  err = -err;
  if (err != HTTP_ERR_NONE) /* error causing packet */
    {
      if (err > -200)
	printf("ERROR %d ", err);
      printf("%s\n", http_err_string(err));
    }

  /*
   * Some printers want to get back at the ethernet addresses,
   * and/or check that they're not walking off the end of the packet.
   * Rather than pass them all the way down, we set these globals.
   */
  packetp = p;
  snapend = p + caplen;

  length -= sizeof(nprobe_hdr_t);
  caplen -= sizeof(nprobe_hdr_t);
  p += sizeof(nprobe_hdr_t);

  ip_print(p, length);
  
  //default_print(p, caplen);

 out:
  putchar('\n');

  return;
}
