/*  -*- Mode: C;  -*- */

/******************************************************************************
*                                                                             *
*   Copyright 2005 University of Cambridge Computer Laboratory.               *
*                                                                             *
*   This file is part of Nprobe.                                              *
*                                                                             *
*   Nprobe is free software; you can redistribute it and/or modify            *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   Nprobe is distributed in the hope that it will be useful,                 *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with Nprobe; if not, write to the Free Software                     *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
*                                                                             *
******************************************************************************/

#include <stdio.h>
#include <ctype.h>

#include "http_errdefs.h"

char *
http_err_string(int err)
{
  char *http_errstrings[] = 
    {
      "no error",		/* HTTP_ERR_NONE 0 */

      "http client header truncated", /* HTTP_CLI_ERR_TRUNCHDR -1 */ 
      "http client unknown method",    /* HTTP_CLI_ERR_REQHDR_NOMETHOD -2 */
      "http client multiple requests on close connection",/* HTTP_CLI_ERR_MULTREQ -3 */
      "http client request header parse",         /* HTTP_CLI_ERR_REQHDR_PARSE -4 */
      "http client - unknown version", /* HTTP_CLI_ERR_VERS -5 */
      "http client length parse", /* HTTPP_CLI_ERR_LEN -6 */
      "http client no body length on persistent connection",/* HTTPP_CLI_ERR_UBL -7 */
      "http client body too long", /* HTTPP_CLI_ERR_BODY_TOO_LONG -8 */
      "http client missing header delimiter", /* HTTPP_CLI_ERR_NO_HDRDELIM -9 */
      "http client missing POST body length", /* HTTP_CLI_ERR_NO_POST_BODYLEN -10 */
      "http client connection type contradiction", /* HTTP_CLI_ERR_PERSISTANCE -11 */
      "http client header too fragmented",  /* HTTP_CLI_ERR_HDRCOP -12 */
      "http client header buffer exhausted",  /* HTTP_CLI_ERR_HDRBUF -13 */
      "http client chunked transfer encoding fail", /* HTTP_CLI_ERR_CHUNK -14 */
      "http client chunked length fail",      /* HTTP_CLI_ERR_CHUNKLEN -15 */
      "http client maximum transactions exceeded",      /* HTTP_CLI_ERR_TRANS_EXC -16 */
      "extraneous bytes in request body", /* HTTP_ERR_CLI_EXBYTES -17 */
      "client found server already serving",  /* HTTP_CLI_SERVER_ACTIVE -18 */
      "client found server transaction in progress", /* HTTP_CLI_SERVER_TRANS_ACTIVE -19 */
      "http client illicit request body", /* HTTP_CLI_ILLICIT_BODY -20 */
      "",			/* PLACEHOLDER -21 */
      "",			/* PLACEHOLDER -22 */
      "",			/* PLACEHOLDER -23 */
      "",			/* PLACEHOLDER -24 */
      "",			/* PLACEHOLDER -25 */
      "",			/* PLACEHOLDER -26 */
      "",			/* PLACEHOLDER -27 */
      "",			/* PLACEHOLDER -28 */
      "",			/* PLACEHOLDER -29 */
      "",			/* PLACEHOLDER -30 */
      "",			/* PLACEHOLDER -31 */
      "",			/* PLACEHOLDER -32 */
      "",			/* PLACEHOLDER -33 */
      "",			/* PLACEHOLDER -34 */
      "",			/* PLACEHOLDER -35 */
      "",			/* PLACEHOLDER -36 */
      "",			/* PLACEHOLDER -37 */
      "",			/* PLACEHOLDER -38 */
      "",			/* PLACEHOLDER -39 */
      "",			/* PLACEHOLDER -40 */
      "",			/* PLACEHOLDER -41 */
      "",			/* PLACEHOLDER -42 */
      "",			/* PLACEHOLDER -43 */
      "",			/* PLACEHOLDER -44 */
      "",			/* PLACEHOLDER -45 */
      "",			/* PLACEHOLDER -46 */
      "",			/* PLACEHOLDER -47 */
      "",			/* PLACEHOLDER -48 */
      "",			/* PLACEHOLDER -49 */
      "",			/* PLACEHOLDER -50 */

      "http server header truncated", /* HTTP_SERV_ERR_TRUNCHDR -51 */
      "http server multiple responses on close connection", /* HTTP_SERV_ERR_MULTREP -52 */
      "http server reply header parse",         /* HTTP_SERV_ERR_REPHDR_PARSE -53 */
      "http server server status code", /* HTTP_SERV_ERR_SCODE -54 */
      "http server - unknown version", /* HTTP_SERV_ERR_VERS -55 */
      "http server length parse", /* HTTPP_SERV_ERR_LEN -56 */
      "http server no body length on persistent connection", /* HTTP_SERV_ERR_UBL -57 */
      "http server body too long", /* HTTPP_SERV_ERR_BODY_TOO_LONG -58 */
      "http server missing header delimiter", /* HTTPP_SERV_ERR_NO_HDRDELIM -59 */
      "http server connection type contradiction", /* HTTP_SERV_ERR_PERSISTANCE -60 */
      "http server header too fragmented",  /* HTTP_SERV_ERR_HDRCOP -61 */
      "http server header buffer exhausted",  /* HTTP_SERV_ERR_HDRBUF -62 */
      "http server chunked transfer encoding fail", /* HTTP_SERV_ERR_CHUNK -63 */
      "http server chunked length fail",      /* HTTP_SERV_ERR_CHUNKLEN -64 */
      "http server maximum transactions exceeded",      /* HTTP_SERV_ERR_TRANS_EXC -65 */
      "http server opening connection",		/* HTTP_SERV_ERR_SERVER_OP -66 */
      "extraneous bytes in object body", /* HTTP_ERR_SERV_EXBYTES -67 */
      "",			/* PLACEHOLDER -68 */
      "",			/* PLACEHOLDER -69 */
      "",			/* PLACEHOLDER -70 */
      "",			/* PLACEHOLDER -71 */
      "",			/* PLACEHOLDER -72 */
      "",			/* PLACEHOLDER -73 */
      "",			/* PLACEHOLDER -74 */
      "",			/* PLACEHOLDER -75 */
      "",			/* PLACEHOLDER -76 */
      "",			/* PLACEHOLDER -77 */
      "",			/* PLACEHOLDER -78 */
      "",			/* PLACEHOLDER -79 */
      "",			/* PLACEHOLDER -80 */
      "",			/* PLACEHOLDER -81 */
      "",			/* PLACEHOLDER -82 */
      "",			/* PLACEHOLDER -83 */
      "",			/* PLACEHOLDER -84 */
      "",			/* PLACEHOLDER -85 */
      "",			/* PLACEHOLDER -86 */
      "",			/* PLACEHOLDER -87 */
      "",			/* PLACEHOLDER -88 */
      "",			/* PLACEHOLDER -89 */
      "html object parse",	/* HTML_ERR_PARSE -90 */
      "html runaway URL",       /* HTML_ERR_RUNAWAY_URL -91 */
      "html links buffers exhausted",/*  HTML_LINKS_BUFS_EXHUSTED -92 */
      "html tag buffer exhausted",/* HTML_TAG_BUF_EXHUSTED -93 */
      "",			/* PLACEHOLDER -94 */
      "",			/* PLACEHOLDER -95 */
      "",			/* PLACEHOLDER -96 */
      "",			/* PLACEHOLDER -97 */
      "",			/* PLACEHOLDER -98 */
      "",			/* PLACEHOLDER -99 */
      "",			/* PLACEHOLDER -100 */
      "html missing <IMG> SRC", /* HTML_ERR_NO_IMGSRC -101 */
      "connection persistence", /*  HTTP_ERR_PERSISTANCE -102 */
      "IP header checksum incorrect", /*IP_ERR_HDRCHKSUM -103 */
      "TCP checksum incorrect", /* TCP_ERR_CHKSUM -104 */
      "TCP server connection error", /* TCP_ERR_SERV_CONNERR -105 */
      "TCP client connection error", /* TCP_ERR_CLI_CONNERR -106 */
      "TCP bad option length",	     /* TCP_ERR_BAD_OPTLEN -107 */
      "TCP option incompatible with flags",/* TCP_ERR_BAD_OPTFLAGS -108 */
      "",			/* PLACEHOLDER -109 */
      "",			/* PLACEHOLDER -110 */
      "",			/* PLACEHOLDER -111 */
      "",			/* PLACEHOLDER -112 */
      "",			/* PLACEHOLDER -113 */
      "",			/* PLACEHOLDER -114 */
      "",			/* PLACEHOLDER -115 */
      "",			/* PLACEHOLDER -116 */
      "",			/* PLACEHOLDER -117 */
      "",			/* PLACEHOLDER -118 */
      "",			/* PLACEHOLDER -119 */
      "tcpdump packet length eror", /* PKT_ERR_LEN -120 */
      "",			/* PLACEHOLDER -121 */
      "",			/* PLACEHOLDER -122 */
      "",			/* PLACEHOLDER -123 */
      "",			/* PLACEHOLDER -124 */
      "",			/* PLACEHOLDER -125 */
      "",			/* PLACEHOLDER -126 */
      "",			/* PLACEHOLDER -127 */
      "",			/* PLACEHOLDER -128 */
      "",			/* PLACEHOLDER -129 */
      "",			/* PLACEHOLDER -130 */
      "",			/* PLACEHOLDER -131 */
      "",			/* PLACEHOLDER -132 */
      "",			/* PLACEHOLDER -133 */
      "",			/* PLACEHOLDER -134 */
      "",			/* PLACEHOLDER -135 */
      "",			/* PLACEHOLDER -136 */
      "",			/* PLACEHOLDER -137 */
      "",			/* PLACEHOLDER -138 */
      "",			/* PLACEHOLDER -139 */
      "NS RR Decode error",	/* HTTP_ERR_NS_DECODE -140 */
      "",			/* PLACEHOLDER -141 */
      "",			/* PLACEHOLDER -142 */
      "",			/* PLACEHOLDER -143 */
      "",			/* PLACEHOLDER -144 */
      "",			/* PLACEHOLDER -145 */
      "",			/* PLACEHOLDER -146 */
      "",			/* PLACEHOLDER -147 */
      "",			/* PLACEHOLDER -148 */
      "",			/* PLACEHOLDER -149 */
      "",			/* PLACEHOLDER -150 */
      "client assert_fail - reference string null", /*HTTP_ASSERT_FAIL_REFSTRNULL -151 */
      "client assert_fail - bad reference string length",/*HTTP_ASSERT_FAIL_REFSTRLEN -152 */
      "",			/* PLACEHOLDER -153 */
      "",			/* PLACEHOLDER -154 */
      "",			/* PLACEHOLDER -155 */
      "",			/* PLACEHOLDER -156 */
      "",			/* PLACEHOLDER -157 */
      "",			/* PLACEHOLDER -158 */
      "",			/* PLACEHOLDER -159 */
      "",			/* PLACEHOLDER -160 */
      "",			/* PLACEHOLDER -161 */
      "",			/* PLACEHOLDER -162 */
      "",			/* PLACEHOLDER -163 */
      "",			/* PLACEHOLDER -164 */
      "",			/* PLACEHOLDER -165 */
      "",			/* PLACEHOLDER -166 */
      "",			/* PLACEHOLDER -167 */
      "",			/* PLACEHOLDER -168 */
      "",			/* PLACEHOLDER -169 */
      "",			/* PLACEHOLDER -170 */
      "",			/* PLACEHOLDER -171 */
      "",			/* PLACEHOLDER -172 */
      "",			/* PLACEHOLDER -173 */
      "",			/* PLACEHOLDER -174 */
      "",			/* PLACEHOLDER -175 */
      "server assert_fail - bad links string copy length",/*HTTP_ASSERT_FAIL_LINKSURL_COPLEN -176 */
      "server assert_fail - bad inlines string copy length",/* HTTP_SERV_ASSERT_FAIL_INLINESURL_COPLEN -177 */
      "server assert_fail - bad scripts string copy length",			/* HTTP_SERV_ASSERT_FAIL_SCRIPTSURL_COPLEN -178 */
      "",			/* PLACEHOLDER -179 */
      "",			/* PLACEHOLDER -180 */
      "",			/* PLACEHOLDER -181 */
      "",			/* PLACEHOLDER -182 */
      "",			/* PLACEHOLDER -183 */
      "",			/* PLACEHOLDER -184 */
      "",			/* PLACEHOLDER -185 */
      "",			/* PLACEHOLDER -186 */
      "",			/* PLACEHOLDER -187 */
      "",			/* PLACEHOLDER -188 */
      "",			/* PLACEHOLDER -189 */
      "",			/* PLACEHOLDER -190 */
      "",			/* PLACEHOLDER -191 */
      "",			/* PLACEHOLDER -192 */
      "",			/* PLACEHOLDER -193 */
      "",			/* PLACEHOLDER -194 */
      "",			/* PLACEHOLDER -195 */
      "",			/* PLACEHOLDER -196 */
      "",			/* PLACEHOLDER -197 */
      "",			/* PLACEHOLDER -198 */
      "",			/* PLACEHOLDER -199 */
      "",			/* PLACEHOLDER -200 */
      "",			/* PLACEHOLDER -201 */
      "Tcp test packet",			/* TCP_TESTPKT -202 */
      "Interesting - RTSP Packet", /* INTERESTING_RTSP_PKT -203 */
      "Interesting - PNM Packet", /* INTERESTING_PNM_PKT -204 */
      "Interesting - DNS Packet" /* INTERESTING_DNS_PKT -205 */
    };

  return http_errstrings[-err];
}

#undef putchar
#define putchar(ch) printf("%c", ch)

void 
print_http_err_data(int err, char *data)
{
  int i;
  if (data == NULL)
    return;

  switch (err)
    {
    case HTTP_CLI_ASSERT_FAIL_REFSTRNULL:
      printf("- first eight octets are:- ");
      for (i = 0; i < 8; i++)
	{
	  if (isprint(data[i]))
	    putchar(data[i]);
	  else
	    printf("[%02x]", data[i]);
	}
      putchar('\n');
      break;

    case HTTP_CLI_ASSERT_FAIL_REFSTRLEN:
      printf("- copied length %u string length %u\n",
	     *((unsigned int *)data), *((unsigned int *)&data[4]));
      break;
      
    case HTTP_SERV_ASSERT_FAIL_LINKSURL_COPLEN:
    case HTTP_SERV_ASSERT_FAIL_INLINESURL_COPLEN:
    case HTTP_SERV_ASSERT_FAIL_SCRIPTSURL_COPLEN:       
      printf("- charlen %u index %u\n",
             *((unsigned int *)data), *((unsigned int *)&data[4]));
      break;

    default:
      printf("no data\n");
    }

  return;
}
      
      
