
/*  -*- Mode: C;  -*- */

/******************************************************************************
*                                                                             *
*   Copyright 2005 University of Cambridge Computer Laboratory.               *
*                                                                             *
*   This file is part of Nprobe.                                              *
*                                                                             *
*   Nprobe is free software; you can redistribute it and/or modify            *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   Nprobe is distributed in the hope that it will be useful,                 *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with Nprobe; if not, write to the Free Software                     *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
*                                                                             *
******************************************************************************/

#ifndef __TCPDUMP_PATCH_H_
#define __TCPDUMP_PATCH_H_

#define TCPDUMP_MAGIC 0xa1b2c3d4
#define TCPDUMP_MAGIC_LINUX 0xa1b2cd34
#define VERSION_MAJOR 2
#define VERSION_MINOR 2

/* macros for when sf_swapped is true: */
/*
 * We use the "receiver-makes-right" approach to byte order,
 * because time is at a premium when we are writing the file.
 * In other words, the file_header and packet_header records
 * are written in host byte order.
 * Note that the packets are always written in network byte order.
 *
 * ntoh[ls] aren't sufficient because we might need to swap on a big-endian
 * machine (if the file was written in little-end order).
 */
#define	SWAPLONG(y) \
((((y)&0xff)<<24) | (((y)&0xff00)<<8) | (((y)&0xff0000)>>8) | (((y)>>24)&0xff))
#define	SWAPSHORT(y) \
	( (((y)&0xff)<<8) | (((y)&0xff00)>>8) )

/*
 * The first record in the file contains saved values for some
 * of the flags used in the printout phases of tcpdump.
 * Many fields here are longs so compilers won't insert unwanted
 * padding; these files need to be interchangeable across architectures.
 */
struct file_header 
{
  unsigned int magic;
  unsigned short version_major;
  unsigned short version_minor;
  int thiszone;		/* gmt to local correction */
  unsigned int sigfigs;	/* accuracy of timestamps */
  unsigned int snaplen;	/* max length saved portion of each pkt */
  unsigned int linktype;
};

/*
 * Each packet in the dump file is prepended with this generic header.
 * This gets around the problem of different headers for different
 * packet interfaces.
 */
struct packet_header 
{
  struct timeval ts;	/* time stamp */
  unsigned int len;		/* length this packet (off wire) */
  unsigned int cap_len;	/* length of portion present */
};
/*
 * And the Linux version
 */
struct linux_packet_header 
{
  struct timeval ts;	/* time stamp */
  unsigned int cap_len;	/* length of portion present */
  unsigned int len;	/* length this packet (off wire) */
  int ifindex;
  unsigned short protocol;
  unsigned char pkt_type;
};

#ifdef TCPDUMP_FED

/*
 * Constants for next_pkt scanning switch
 */
#define NOT_SCANNING 0
#define SCANNING 1

extern int sf_swapped;
extern int linux_format;
void open_tcpdumpfile(link_data_t *ld); 
long next_pkt(bufrec_t *buffer);
int scan(bufrec_t *bp, struct linux_packet_header *hp);

#endif

#endif /* __TCPDUMP_PATCH_H_ */


/*
 * end tcpdump_patch.h 
 */
