/*  -*- Mode: C;  -*- */

/******************************************************************************
*                                                                             *
*   Copyright 2005 University of Cambridge Computer Laboratory.               *
*                                                                             *
*   This file is part of Nprobe.                                              *
*                                                                             *
*   Nprobe is free software; you can redistribute it and/or modify            *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   Nprobe is distributed in the hope that it will be useful,                 *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with Nprobe; if not, write to the Free Software                     *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
*                                                                             *
******************************************************************************/

#ifndef _TCP_TEST_H_
#define _TCP_TEST_H_

void tcp_test_open(prec_t *pp, struct tcp_conn *tconnp, int way, unsigned char flags);
void tcp_test_close(prec_t *pp, struct tcp_conn *tconnp, int way, unsigned char flags);
int tcp_test_pkt(prec_t *pp, struct tcp_conn *tconnp, int way);
int tcp_test_sync(struct tcp_heldpkt *hpp, struct tcp_conn *tconnp, 
		  struct tcp_simplex_flow *tsp, unsigned int gap, int way, 
		  unsigned int tm);  
void tcp_test_dump(struct tcp_conn *tconnp);

void test_pkt_arrive(tcp_conn_t *tconnp, int way, unsigned int seq, unsigned int ack, int len, unsigned char flags);
void test_pkt_hold(tcp_conn_t *tconnp, tcp_simplex_flow_t *tsp, tcp_heldpkt_t *hpp);
void test_pkt_do(struct tcp_conn *tconnp, tcp_simplex_flow_t *tsp, int way, unsigned int seq, int len, unsigned char flags);
void test_pkt_do_end(struct tcp_conn *tconnp, tcp_simplex_flow_t *tsp);

#ifdef TCP_TEST

#define TCP_TEST_PKT_ARRIVE(tconnp, way, seq, ack, len, flags) \
MACRO_BEGIN        \
  if ((tconnp)->flow_common.inner.serv_type == TCP_SERV_TEST) \
    test_pkt_arrive((tconnp), (way), (seq), (ack), (len), (flags)); \
MACRO_END

#define TCP_TEST_PKT_HOLD(tconnp, tsp, hpp) \
MACRO_BEGIN        \
  if ((tconnp)->flow_common.inner.serv_type == TCP_SERV_TEST) \
    test_pkt_hold((tconnp), (tsp), (hpp)); \
MACRO_END

#define TCP_TEST_PKT_DO(tconnp, tsp, way, seq, len, flags) \
MACRO_BEGIN        \
  if ((tconnp)->flow_common.inner.serv_type == TCP_SERV_TEST) \
    test_pkt_do((tconnp), (tsp), (way), (seq), (len), (flags)); \
MACRO_END

#define TCP_TEST_PKT_DO_END(tconnp, tsp) \
MACRO_BEGIN        \
  if ((tconnp)->flow_common.inner.serv_type == TCP_SERV_TEST) \
    test_pkt_do_end((tconnp), (tsp)); \
MACRO_END

#else

#define TCP_TEST_PKT_ARRIVE(tconnp, way, seq, ack, len, flags)
#define TCP_TEST_PKT_HOLD(tconnp, tsp, hpp)
#define TCP_TEST_PKT_DO(tconnp, tsp, way, seq, len, flags)
#define TCP_TEST_PKT_DO_END(tconnp, tsp)

#endif

#endif /* _TCP_TEST_H_ */

/*
 * end tcp_test.h 
 */
