/*  -*- Mode: C;  -*- */

/******************************************************************************
*                                                                             *
*   Copyright 2005 University of Cambridge Computer Laboratory.               *
*                                                                             *
*   This file is part of Nprobe.                                              *
*                                                                             *
*   Nprobe is free software; you can redistribute it and/or modify            *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   Nprobe is distributed in the hope that it will be useful,                 *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with Nprobe; if not, write to the Free Software                     *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
*                                                                             *
******************************************************************************/

#ifndef _TCP_OTHER_H_
#define _TCP_OTHER_H_

void tcp_other_open_na(prec_t *pp, struct tcp_conn *tconnp, int way, unsigned char flags);
void tcp_other_close_na(prec_t *pp, struct tcp_conn *tconnp, int way, unsigned char flags);
int tcp_other_pkt_na(prec_t *pp, struct tcp_conn *tconnp, int way);
int tcp_other_sync_na(struct tcp_heldpkt *hpp, struct tcp_conn *tconnp, 
		   struct tcp_simplex_flow *tsp, unsigned int gap, int way, 
		   unsigned int tm);  
void tcp_other_dump_na(struct tcp_conn *tconnp);
void tcp_other_dump_summary(struct tcp_conn *tconnp);

void tcp_test_open(prec_t *pp, struct tcp_conn *tconnp, int way, unsigned char flags);
void tcp_test_close(prec_t *pp, struct tcp_conn *tconnp, int way, unsigned char flags);
int tcp_test_pkt(prec_t *pp, struct tcp_conn *tconnp, int way);
int tcp_test_sync(struct tcp_heldpkt *hpp, struct tcp_conn *tconnp, 
		 struct tcp_simplex_flow *tsp, unsigned int gap, int way, 
		  unsigned int tm);  
void 
tcp_test_dump(struct tcp_conn *tconnp);

extern tcp_serv_methods_t tcp_other_serv_methods_na;
extern tcp_serv_methods_t tcp_other_serv_methods_summary;

extern serv_control_t tcp_other_serv_control_na;
extern serv_control_t tcp_other_serv_control_summary;
extern serv_control_t tcp_other_serv_control_open_summary;
extern serv_control_t tcp_other_serv_control_open_hdrs_summary;

#endif /* _TCP_OTHER_H_ */

/*
 * end tcp_other.h 
 */
