/*  -*- Mode: C;  -*- */

/******************************************************************************
*                                                                             *
*   Copyright 2005 University of Cambridge Computer Laboratory.               *
*                                                                             *
*   This file is part of Nprobe.                                              *
*                                                                             *
*   Nprobe is free software; you can redistribute it and/or modify            *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   Nprobe is distributed in the hope that it will be useful,                 *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with Nprobe; if not, write to the Free Software                     *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
*                                                                             *
******************************************************************************/

#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <sys/param.h>
#include <string.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#ifdef __alpha__
#include <sys/mbuf.h>
#endif
#include <net/route.h>
#include <net/if.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#undef __STDC__
#include <netinet/ip.h>

#ifdef __alpha__
#include <netinet/ip_var.h>
#endif
#include <netinet/tcp.h>
#include <netinet/if_ether.h>

#include <assert.h>

#include "list.h"
#include "pkt.h"
#include "interface.h"
#include "flows.h"
#include "http.h"
//#include "tcp_other.h"
#include "tcp.h"
#include "udp.h"
#include "service.h"
#include "udp_ns.h"
#include "seq.h"
#include "report.h"

#ifdef PRINT_OUT
#include "print_util.h"
#endif

#include "output.h"
#include "writer.h"
#include "pool.h"


void 
tcp_ftp_open(prec_t *pp, struct tcp_conn *tconnp, int way, unsigned char flags)
{
  return;
}

void 
tcp_ftp_close(prec_t *pp, struct tcp_conn *tconnp, int way, unsigned char flags)
{
  return;
}

int 
tcp_ftp_pkt(prec_t *pp, struct tcp_conn *tconnp, int way)
{
  return 0;
}


int 
tcp_ftp_sync(struct tcp_heldpkt *hpp, struct tcp_conn *tconnp, 
	     struct tcp_simplex_flow *tsp, unsigned int gap, int way, 
	     unsigned int tm)
{
  return 1;
}
  
void 
tcp_ftp_dump(struct tcp_conn *tconnp)
{
  int client_seen = TCP_STATE & TCP_CLIENT_SEEN;
  int server_seen = TCP_STATE & TCP_SERVER_SEEN;

  rec_dump_start();
  /* tcp part */
  tcp_dump(tconnp, client_seen, server_seen);

  rec_dump_end(REC_TCP_FTP);
  
  return;
}

tcp_serv_methods_t tcp_ftp_serv_methods = 
  {
    tcp_ftp_open,
    tcp_ftp_pkt,
    tcp_ftp_sync,
    tcp_ftp_close,
    tcp_ftp_dump
  };

serv_control_t tcp_ftp_serv_control = 
  {
    {
      &tcp_ftp_serv_methods
    },
    {
      REC_TCP_FTP_OPEN, REC_TCP_FTP_HDRS, REC_TCP_FTP, TCP_SERV_FTP
    },
    &counters.TRAFF_TCP_FTP,
    NO_DUMP
  };  


void 
tcp_ftp_data_open(prec_t *pp, struct tcp_conn *tconnp, int way, unsigned char flags)
{
  return;
}

void 
tcp_ftp_data_close(prec_t *pp, struct tcp_conn *tconnp, int way, unsigned char flags)
{
  return;
}

int 
tcp_ftp_data_pkt(prec_t *pp, struct tcp_conn *tconnp, int way)
{
  return 0;
}


int 
tcp_ftp_data_sync(struct tcp_heldpkt *hpp, struct tcp_conn *tconnp, 
		 struct tcp_simplex_flow *tsp, unsigned int gap, int way, 
		  unsigned int tm)
{
  return 1;
}
  
void 
tcp_ftp_data_dump(struct tcp_conn *tconnp)
{
  int client_seen = TCP_STATE & TCP_CLIENT_SEEN;
  int server_seen = TCP_STATE & TCP_SERVER_SEEN;

  rec_dump_start();
  /* tcp part */
  tcp_dump(tconnp, client_seen, server_seen);

  rec_dump_end(REC_TCP_FTP_DATA);
  
  return;
}

tcp_serv_methods_t tcp_ftp_data_serv_methods = 
{
  tcp_ftp_data_open,
  tcp_ftp_data_pkt,
  tcp_ftp_data_sync,
  tcp_ftp_data_close,
  tcp_ftp_data_dump
};

serv_control_t tcp_ftp_data_serv_control = 
  {
    {
      &tcp_ftp_data_serv_methods
    },
    {
      REC_TCP_FTP_DATA_OPEN, REC_TCP_FTP_DATA_HDRS, REC_TCP_FTP_DATA, TCP_SERV_FTP_DATA
    },
    &counters.TRAFF_TCP_FTP_DATA,
    NO_DUMP
  };  
