/*  -*- Mode: C;  -*- */

/******************************************************************************
*                                                                             *
*   Copyright 2005 University of Cambridge Computer Laboratory.               *
*                                                                             *
*   This file is part of Nprobe.                                              *
*                                                                             *
*   Nprobe is free software; you can redistribute it and/or modify            *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   Nprobe is distributed in the hope that it will be useful,                 *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with Nprobe; if not, write to the Free Software                     *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
*                                                                             *
******************************************************************************/


#ifndef _TCP_BGP_H_
#define _TCP_BGP_H_

void tcp_bgp_open(prec_t *pp, struct tcp_conn *tconnp, int way, unsigned char flags);
void tcp_bgp_close(prec_t *pp, struct tcp_conn *tconnp, int way, unsigned char flags);
int tcp_bgp_pkt(prec_t *pp, struct tcp_conn *tconnp, int way);
int tcp_bgp_sync(struct tcp_heldpkt *hpp, struct tcp_conn *tconnp, 
		   struct tcp_simplex_flow *tsp, unsigned int gap, int way, 
		   unsigned int tm);   
void tcp_bgp_dump(struct tcp_conn *tconnp);

extern serv_control_t tcp_bgp_serv_control;


#endif /* _TCP_BGP_H_ */

/*
 * end tcp_other.h 
 */
