/*  -*- Mode: C;  -*- */

/******************************************************************************
*                                                                             *
*   Copyright 2005 University of Cambridge Computer Laboratory.               *
*                                                                             *
*   This file is part of Nprobe.                                              *
*                                                                             *
*   Nprobe is free software; you can redistribute it and/or modify            *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   Nprobe is distributed in the hope that it will be useful,                 *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with Nprobe; if not, write to the Free Software                     *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
*                                                                             *
******************************************************************************/

#ifndef _PRINT_UTIL_H_
#define _PRINT_UTIL_H_

/*
 * Switch for hostname conversion 
 */
#define USE_HOSTNAMES
//#undef USE_HOSTNAMES

#ifndef SWIG
#ifdef WREAD
#define USE_HOSTNAMES
#endif
#endif


#ifdef PRINT_OUT

extern int print_packets;

#endif

extern int print_hostnames;

/*
 * Used by dns reporting 
 */

struct tok {
        int v;                  /* value */
        char *s;                /* string */
};



/*
 * print_util.c 
 */

#if defined SWIG_ONLY || defined SWIG
extern char null_string[];
#endif

extern char *ns_ops[];
extern char *ns_resp[];
extern struct tok class2str[];
extern struct tok type2str[];

void nsbuf(ns_fullrec_t *nfp);
const char *tok2str(struct tok *lp, char *fmt, int v);

void print_ts(tmval *tvp, FILE *f);
char *time_string(tmval *tvp);
char *intoa(unsigned int addr);
char *ts_string(tmval *tvp);
char *get_hname(char *ap);
void print_tcp_flags(unsigned char flags, FILE *f);
char *tcpudp_port_string(unsigned short port, char prot);
char *get_atmaddr(unsigned int atmdata);
void print_tcpopts(char *tcpoptp, int len, FILE *f);
#ifdef TCPDUMP_FED
void print_http(char *start, int len, int trunc, tcp_conn_t *tconnp, FILE *f, int way);
#else
void print_http(char *start, int len, tcp_conn_t *tconnp, FILE *f, int way);
#endif

char *method_string(unsigned char meth);
char *status_string(short code);
void print_flow(FILE *f, flow_inner_t *tc, int way);
char *np_rectype_str(unsigned char type);

void print_hdr_rec(FILE *f, struct tcp_dumphdr *hdr, us_clock_t *atm);
//char *content_type_string(unsigned short ct);
char *content_type_string(int ct);
char *tcp_pload_string(unsigned char plt);
char *udp_pload_string(unsigned char plt);
int print_seq2str(FILE *f, char *seq, unsigned char len);
char *http_versions_string(unsigned int vers);
void print_links_buf(FILE *f, unsigned char *buf, int buflen, char *label);
void print_discrete_links_buf(struct links_chars *chars, char *title);
char *link_rec_type_string(unsigned short type);

char *icmp_type_string(unsigned char type);
char *icmp_code_string(unsigned char code);

#ifndef SWIG_ONLY
char *us_clock_ts_string(us_clock_t t);
char *us_clock_time_string(us_clock_t t);
char *us_ts_string(unsigned int t);
void print_content(prec_t *pp);
#endif /* ifndef SWIG_ONLY */


#endif /* _PRINT_UTIL_H_ */


/*
 * end print_util.h 
 */
