/*  -*- Mode: C;  -*- */

/******************************************************************************
*                                                                             *
*   Copyright 2005 University of Cambridge Computer Laboratory.               *
*                                                                             *
*   This file is part of Nprobe.                                              *
*                                                                             *
*   Nprobe is free software; you can redistribute it and/or modify            *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   Nprobe is distributed in the hope that it will be useful,                 *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with Nprobe; if not, write to the Free Software                     *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
*                                                                             *
******************************************************************************/

#ifndef _WEBTRAFFIC_H_
#define _WEBTRAFFIC_H_

#include "basic_defs.h"
#include "http_errdefs.h"

/*******************************************************************/

#ifdef PROBE_FED

#include <skb.h>
#include <probe.h>

extern int chan;
void put_skb( int chan, struct sk_buff * skb );
inline void * kern2user( void * kern );

#define FREE_BUFF(b)
#define FREE_BUFREC(br) put_skb(chan, br)
#define FREE_PREC(pp) recycle_prec_t(pp)

typedef struct sk_buff bufrec_t;

#define tstamp brecp->stamp          /* these are all skb's */
#define wirelen brecp->len
#define link_type XXXX 
#define buf_start(pp) ( kern2user(pp->brecp->data) )
#define buf_head(pp) ( kern2user(pp->brecp->head) )
#define ATM_DATA *((unsigned int *)buf_head(pp))

#endif /* if PROBE_FED */

typedef struct link_data 
{
  FILE *inf;
  int stdin; /* True if input from stdin */
  int linktype;
  int (*linkstripper)();
  int snaplen;
  /* true if the savefile was collected with linux extended tcpdump stamps */
  int linux_format;
  /* true if the contents of the savefile being read are byte-swapped */
  int sf_swapped;
  /* true if pcap hdr cap_len and len fields need interchanging */
  int swap_len;
  /* Offset of last pkt record read */
  long last_offset;
  unsigned short version_minor;
  char *fnm;
} link_data_t;

/*******************************************************************/
#ifdef TCPDUMP_FED

#define FREE_BUFF(b) free(b)
//#define FREE_BUFREC(br) free(br)
#define FREE_BUFREC(br) recycle_bufrec_t(br)
#define FREE_PREC(pp) recycle_prec_t(pp)

/*
 * For the moment assuming some sort of buffer record which we are handed 
 * and which tells us what we need to know 
 */


typedef struct bufrec 
{
  struct timeval ts;		/* when arrived */
  int plength;			/* length off wire */
  unsigned char *base;		/* start of packet buffer or pool link*/
  link_data_t *link_data;
} bufrec_t;

/*
 * Access to fields in struct bufrec 
 */


#define tstamp    brecp->ts
#define wirelen   brecp->plength
#define link_type brecp->link_data->linktype
#define buf_start(pp) (pp->brecp->base)
#define ATM_DATA pp->atmdata

#endif /* TCPDUMP_FED */

/*******************************************************************/

typedef struct prec 
{
  struct prec *next;		/* used only for pool list */
  bufrec_t *brecp;

  us_clock_t arr_tm;		/* arrival time in ms - used for timeouts */
  unsigned char *buf;			/* where in buffer we are now */
  int len;			/* and how much remaining */
  int trunc;			/* truncation from claimed IP length */
#ifdef TCPDUMP_FED
  unsigned int atmdata;
#endif
 listhdr_t *flowlist;		/* ptr. to host/host hash table slot*/
} prec_t;

/*******************************************************************/

/* free input buffer and associated data structures */
#define FREE_INBUF(pp) \
  MACRO_BEGIN \
    FREE_BUFF(buf_start(pp)); FREE_BUFREC((pp)->brecp); FREE_PREC(pp);\
  MACRO_END

/*******************************************************************/


/* Adjust packet buffer by length */
#define ADJUST(buffer, length)                   \
  MACRO_BEGIN                         \
    (buffer)->buf += (length);                 \
    (buffer)->len -= (length);                  \
  MACRO_END

#ifdef TCPDUMP_FED
#define caplen brecp->snaplen
#endif

#define IS_WEB_CLIENT (dport == 80 || dport == 8080 || dport == 8008)
#define IS_WEB_SERVER (sport == 80 || sport == 8080 || sport == 8008)
#define IS_WWW (IS_WEB_CLIENT || IS_WEB_SERVER)


/**********************************************************************/

#define GETTIMEOFDAY(where, tsp, tzp) \
  MACRO_BEGIN  \
    if (gettimeofday(tsp, tzp) != 0) \
      error(where, "gettimeofday"); \
   MACRO_END


/**********************************************************************/

#define US_GETTIMEOFDAY(where, tm) \
  MACRO_BEGIN  \
    struct timeval tv; \
    GETTIMEOFDAY((where), &tv, (struct timezone *)0); \
      (tm) = (tv.tv_sec*1000000) + tv.tv_usec; \
   MACRO_END

/**********************************************************************/
extern void *mmap_km;
extern void *mmap_km_np;




/**********************************************************************/


/*
 * performance_timer.c 
 */

void get_start(struct timeval *start);
void get_end(struct timeval *end);
double calc_period(struct timeval *start, struct timeval *end);


#include "counters.h"

/* 
 * pkt.c 
 */

void do_pkt(bufrec_t *bp, listhdr_t *host_hashtbl);

extern int do_ip(prec_t *pp, listhdr_t *host_hashtbl);
extern int do_tcp(prec_t *pp, struct ip *ipp, us_clock_t us_time);

#ifdef TCPDUMP_FED
extern struct timeval curr_tm_tv;
extern int dummy_atm_data;
extern int pno;
#endif

/*
 * error.c 
 */
#ifndef WREAD
extern char *last_sync;
void error(char *msg, char *pmsg);
void inform(char *col, char *emsg);
#endif

#endif /* _WEBTRAFFIC_H_ */


/*
 * end webtraffic.h 
 */
