/******************************************************************************
*                                                                             *
*   Copyright 2005 University of Cambridge Computer Laboratory.               *
*                                                                             *
*   This file is part of Nprobe.                                              *
*                                                                             *
*   Nprobe is free software; you can redistribute it and/or modify            *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   Nprobe is distributed in the hope that it will be useful,                 *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with Nprobe; if not, write to the Free Software                     *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
*                                                                             *
******************************************************************************/


#ifndef _ACE_CLK_H_
#define _ACE_CLK_H_


#define ACE_CAL_PER 5000000

typedef volatile unsigned int vul;

struct ace_clk
{
  
  unsigned long long sysclock_start;
  unsigned long long ts_start;
  unsigned long long sysclock_base;
  unsigned long long ts_base;
  unsigned long long wrap;
  unsigned long long last_us;
  double freq;
  unsigned int last_tstamp;
  vul * tstampp;
  int chan;
}; 

typedef struct ace_clk acenic_clk_t;
  

inline long acenic_getcurtime();
inline unsigned long long acenic_maptotimeofday( unsigned int ace_tstamp);
int acenic_start_clock(int chan);





#endif /* _ACE_CLK_H_ */
